******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74ALVCH16721
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2005, (C) COPYRIGHT 2005, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74alvch16721.inc'
X__SN74ALVCH16721 NOE Q1 Q2 GND Q3 Q4 VCC Q5 Q6 Q7 GND Q8 Q9 Q10 Q11 Q12 Q13
+ GND Q14 Q15 Q16 VCC Q17 Q18 GND Q19 Q20 NC NCLKEN D20 D19 GND D18 D17 VCC D16
+ D15 D14 GND D13 D12 D11 D10 D9 D8 GND D7 D6 D5 VCC D4 D3 GND D2 D1 CLK
+ SN74ALVCH16721
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT=0.9 $ input threshold voltage
.param PMAX=50ns $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+PMAX+20n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 NOE 0 DC 0
*VC0 NOE 0 DC 'PVCC'
VC1 NCLKEN 0 DC 0
*VC1 NCLKEN 0 DC 'PVCC'


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 D1 0 pulse 0 'PVIN' 'PDELAY1' 'PRFT' 'PRFT' 'PPW1' 'PPD1'
VI1 CLK 0 pulse 0 'PVIN' 'PDELAY1' 'PRFT' 'PRFT' 3ns 10ns


* CHANGE TO THE OUTPUT NODE
VDATA Q1 DATA DC 0
RLOAD DATA VCC 1000

* VOLTAGE SUPPLIES

.param PVCC=1.8
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 NOE 0 1G
* R1G_2 Q1 0 1G
R1G_3 Q2 0 1G
* R1G_4 GND 0 1G
R1G_5 Q3 0 1G
R1G_6 Q4 0 1G
* R1G_7 VCC 0 1G
R1G_8 Q5 0 1G
R1G_9 Q6 0 1G
R1G_10 Q7 0 1G
* R1G_11 GND 0 1G
R1G_12 Q8 0 1G
R1G_13 Q9 0 1G
R1G_14 Q10 0 1G
R1G_15 Q11 0 1G
R1G_16 Q12 0 1G
R1G_17 Q13 0 1G
* R1G_18 GND 0 1G
R1G_19 Q14 0 1G
R1G_20 Q15 0 1G
R1G_21 Q16 0 1G
* R1G_22 VCC 0 1G
R1G_23 Q17 0 1G
R1G_24 Q18 0 1G
* R1G_25 GND 0 1G
R1G_26 Q19 0 1G
R1G_27 Q20 0 1G
R1G_28 NC 0 1G
R1G_29 NCLKEN 0 1G
R1G_30 D20 0 1G
R1G_31 D19 0 1G
* R1G_32 GND 0 1G
R1G_33 D18 0 1G
R1G_34 D17 0 1G
* R1G_35 VCC 0 1G
R1G_36 D16 0 1G
R1G_37 D15 0 1G
R1G_38 D14 0 1G
* R1G_39 GND 0 1G
R1G_40 D13 0 1G
R1G_41 D12 0 1G
R1G_42 D11 0 1G
R1G_43 D10 0 1G
R1G_44 D9 0 1G
R1G_45 D8 0 1G
* R1G_46 GND 0 1G
R1G_47 D7 0 1G
R1G_48 D6 0 1G
R1G_49 D5 0 1G
* R1G_50 VCC 0 1G
R1G_51 D4 0 1G
R1G_52 D3 0 1G
* R1G_53 GND 0 1G
R1G_54 D2 0 1G
* R1G_55 D1 0 1G
R1G_56 CLK 0 1G

.END
