************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
 .OPTIONS POST                $ Enables HSPLOT interface
 .OPTIONS ACCT OPTS           $ Prints stats & option values used
 .OPTIONS SPICE=1             $ Forces Berkeley compatibility
 .OPTIONS GMIN=1E-12          $ Lowest allowable conductance values
 .OPTIONS GMINDC=1E-12
 .OPTIONS ITL1=400            $ Maximum DC iteration limit
 .OPTIONS ITL4=40             $ Maximum transient iterations/timestep
 .OPTIONS ITL5=0              $ No limit to total transient iterations



***********************************************************************
***********************************************************************
	.OPTIONS search='./'

* ENCRYPTED DEVICE NETLIST and PROCESS Models. 
*INSTRUCTION- Please remove the comment character (*) from the encrypted device net-list 
* and from any one of the corresponding encrypted nominal, strong and weak  file when testing
* the encrypted net-lits and process file


X_DEVICE_SELECTOR  0 AHC541INC   $ Encrypted device net-list
X_PROCESS_SELECTOR 0  EPIC1SNINC    $ Encrypted nominal process model 
*X_PROCESS_SELECTOR 0  EPIC1SSINC    $ Encrypted strong process model
*X_PROCESS_SELECTOR 0  EPIC1SWINC   $ Encrypted weak process model


*Please include any one of the package. You need to change the corresponding package sub-*circuit name for connection.

.INCLUDE  SSOP20.PKG
*.INCLUDE  TVSOP20.PKG
*.INCLUDE  SOIC20.PKG
*.INCLUDE  PDIP20.PKG
*.INCLUDE  SOP20.PKG
*.INCLUDE  TSSOP20.PKG

***********************************************************************
* Refer to the data sheet for node description.
*


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
xahc541

+x_a1       
+x_y1
+x_oe1
+x_oe2
+cgnd
+cvcc


+ahc541

***********************************************************************
******Supply Voltages
***********************************************************************

vcgnd		cgnd	0  dc  0
Vcvcc		cvcc  0  dc 5

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.SUBCKT ahc541  

+p_a1		$PIN_02
+p_y1		$PIN_18
+p_oe1		$PIN_01
+p_oe2		$PIN_19
+p_cgnd		$PIN_10
+p_cvcc		$PIN_20

X_PIN02      	p_a1      	a1  	SSOP20_02
X_PIN18      	p_y1      	y1  	SSOP20_18
X_PIN01      	p_oe1      	oe1  	SSOP20_01
X_PIN19      	p_oe2      	oe2  	SSOP20_19
X_PIN10		p_cgnd		cgnd	SSOP20_10
X_PIN20		p_cvcc		cvcc	SSOP20_20
 
X_ahc541__bit  a1 y1 oe1 oe2 cgnd cvcc  ahc541__bit
.ENDs ahc541

***********************************************************************
***********************************************************************
.temp 50
.param biashv=3.3v
.param biaslv=0.0
.param supplyv=5v
.param capload=50p
.param resload =500
.param loadv=6

V_load load 0 DC loadv
***********************************************************************
.TRAN         1NS 100NS
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

Va1	   x_a1	  cgnd	PULSE (0  5 5NS  1NS  1NS  20NS  50ns)
Voe1       x_oe1  cgnd  DC 0
Voe2       x_oe2  cgnd  DC 0
R_LOAD     x_y1      cgnd     	resload
C_LOAD     x_y1     cgnd     	capload
.END
