******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for PCA9546A
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2007, (C) COPYRIGHT 2007, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'pca9546a.inc'
X__PCA9546A A0 A1 NRESET SD0 SC0 SD1 SC1 GND SD2 SC2 SD3 SC3 A2 SCL SDA VCC E0
+ PCA9546A
*** PULSE PARAMETERS ***
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+40n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 E0 GND PULSE 0 'PVCC' 5ns 2ns 2ns 18ns 40ns


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VP0 SDA GND PULSE 0 'PVCC' 5ns 2ns 2ns 8ns 20ns

* CHANGE TO THE OUTPUT NODE
VDATA SD0 DATA DC 0
RLOAD DATA GND 500

* VOLTAGE SUPPLIES
.param PVCC=5.0
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
R1G_1 A0 0 1G
R1G_2 A1 0 1G
R1G_3 NRESET 0 1G
* R1G_4 SD0 0 1G
R1G_5 SC0 0 1G
R1G_6 SD1 0 1G
R1G_7 SC1 0 1G
* R1G_8 GND 0 1G
R1G_9 SD2 0 1G
R1G_10 SC2 0 1G
R1G_11 SD3 0 1G
R1G_12 SC3 0 1G
R1G_13 A2 0 1G
R1G_14 SCL 0 1G
* R1G_15 SDA 0 1G
* R1G_16 VCC 0 1G

.END
