/* --COPYRIGHT--,BSD
 * Copyright (c) 2019, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//*****************************************************************************
//  Dual Ray AFE Application Configuration
//
//  Static and default configuration of Demo Application
// Texas Instruments, Inc.
// Luis R
#ifndef __DUALRAYSMOKEAFE_APP_CONFIG_H__
#define __DUALRAYSMOKEAFE_APP_CONFIG_H__
#include <stdint.h>
#include <stdbool.h>

//*********** Static Configuration *********************************************

//*********** Default Dynamic Configuration ************************************
//! \brief Default interval of Ultra Low Power Timer in ms.
//!         This timer defines the period at which mesurements are taken.
//!         I.e. 1000 = 1000ms
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_ULPTIMER_INTERVAL_MSEC        (10000)

//! \brief Default calibration interval of Ultra Low Power Timer.
//!         Set in measurement cycles.
//!         I.e. 60 = 60secs if ULP Timer interval is 1sec.
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_ULPTIMER_CALIBRATION_INTERVAL (60)

//! \brief Default Temperature sensor measurement interval.
//!         Set in measurement cycles.
//!         I.e. 5 = 5secs if ULP Timer interval is 1sec.
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_TEMPERATURESENSOR_INTERVAL      (5)

//! \brief Interval of Low Power Timer in ms.
//!         This timer is used to trigger periodic functions such as tracking
//!         test button debounce, and alarm timings
//!         I.e. 100 = 100ms
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_LPPERTIMER_INTERVAL_MSEC        (100)

//! \brief Number of seconds before turning OFF alarm after being activated
//!         and if no smoke is detected.
//!         I.e. 5 = 5 secs
//!
#define DUALRAYSMOKEAFE_APP_ALARM_ONTOOFF_SILENT_SEC                (5)

//! \brief Number of seconds with the alarm desactivated (silent) when test
//!         button is pressed after being ON.
//!         I.e. 6 = 6 secs
//!
#define DUALRAYSMOKEAFE_APP_ALARM_SILENT_SEC                        (6)

//! \brief Default state of alarm.
//!         true if alarm is ON, false if not.
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_ALARMON                         (false)

//! \brief Default state of alarm detection.
//!         true if alarm detection is enabled, false if not.
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_ALARMDETECTIONENABLED           (true)

//! \brief Default state of horn/sounder enable.
//!         true if horn/sounder is enabled, false if not.
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_HORNENABLED                     (false)

//! \brief Default state of temperature measurement enable.
//!         true if temperature measurement is enabled, false if not.
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_TEMPERATUREMEASENABLED          (true)

//! \brief Default state of RTC calibration.
//!         true if RTC calibration is enabled, false if not.
//!
#define DUALRAYSMOKEAFE_APP_DEFAULT_RTCCALIBENABLED                 (false)

#endif //__DUALRAYSMOKEAFE_APP_CONFIG_H__
