*Rev.a May-2007
.SUBCKT LMH6551 1001 1002 1003 1004 1005 1006 1007
*SUBCKT LMH6551 IN+  IN-  V+   V-   VCM  OUT+ OUT-
*//////////////////////////////////////////////////////////////////////
* LMH6551 SPICE MODEL
*//////////////////////////////////////////////////////////////////////
*
* LMH6551 SPICE MODEL CONNECTIONS
* IN+  1001
* IN-  1002
* V+   1003
* V-   1004
* VCM  1005
* OUT+ 1006
* OUT- 1007
*
*//////////////////////////////////////////////////////////////////////
*
* (C) National Semiconductor, Corporation.
* Models developed and under copyright by:
* National Semiconductor, Corporation. 
*
*//////////////////////////////////////////////////////////////////////
*
* Legal Notice:  
* The model may be copied, and distributed without any modifications;
* however, reselling or licensing the material is illegal.
* We reserve the right to make changes to the model without prior notice. 
* Pspice Models are provided "AS IS, WITH NO WARRANTY OF ANY KIND" 
*
*////////////////////////////////////////////////////////////////////
* LMH6551 SPICE MODEL PERFORMANCE
*
* MODEL FEATURES INCLUDE:
* DIFFERENTIAL VOLTAGE GAIN AND PHASE
* OUTPUT VOLTAGE SWING
* CURRENT THROUGH POWER SUPPLY RAILS
* COMMON MODE VOLTAGE GAIN (REJECTION) AS A FUNCTION OF FREQUENCY
* POWER SUPPLY REJECTION AS A FUNCTION OF FREQUENCY
* OPEN AND CLOSED LOOP BANDWIDTH
* SLEW RATE
* INPUT OFFSET VOLTAGE
* INPUT BIAS CURRENT
* SHORT CIRCUIT CURRENT
* QUIESCENT SUPPLY CURRENT
* 
* NOTE:
* TO CHANGE THE INPUT OFFSET VOLTAGE, CHANGE V_V33 FROM IT'S 
* DEFAULT VALUE OF 100UV. A CHANGE IN THIS SOURCE VOLTAGE
* WILL PRODUCE A PROPORTIONAL CHANGE IN INPUT OFFSET VOLTAGE
*
*/////////////////////////////////////////////////////////////
*
* MODEL TEMP RANGE IS -55 TO +125 DEG C.
* NOTE THAT THE MODEL IS FUNCTIONAL OVER THIS RANGE BUT NOT
* ALL PARAMETERS TRACK THOSE OF THE REAL PART.
*
*///////////////////////////////////////////////////////////
.MODEL QN NPN BF=200 VAF=100 RB=80 KF=1E-16 IKF=0.1 RE=.1M RC=.1M CJE=5f CJC=5f
.MODEL QP PNP BF=100 VAF=100 RB=80 KF=1E-16 IKF=0.1 RE=.1M RC=.1M CJE=5f CJC=5f
C_C1 115 101  0.3p  
C_C2 102 118  0.3p  
C_C3 134 105  0.3p  
C_C4 141 106  0.3p  
C_C5 1004 170  .5p  
E_E1 146 0 153 0 .99986
I_I1 146 152 DC 1.2uA  
I_I2 123 1001 DC 1.2uA  
Q_Q1 1003 107 108 Qn 2
Q_Q10 102 102 122 Qn 1
Q_Q11 1004 123 124 Qp 1
Q_Q12 101 125 126 Qn 1
Q_Q13 1003 123 127 Qn 1
Q_Q14 102 128 126 Qp 1
Q_Q15 1004 1001 123 Qp 1
Q_Q16 123 104 129 Qp 4
Q_Q17 124 104 130 Qp 4
Q_Q18 127 103 131 Qn 4
Q_Q19 1003 132 133 Qn
Q_Q2 109 104 110 Qp 2
Q_Q20 134 105 135 Qp 2
Q_Q21 136 105 137 Qp 2
Q_Q22 105 105 138 Qp 1
Q_Q23 1004 140 139 Qp 1
Q_Q24 1004 142 134 Qp 2
Q_Q25 1003 136 141 Qn 2
Q_Q26 141 106 143 Qn 2
Q_Q27 142 106 144 Qn 2
Q_Q28 106 106 145 Qn 1
Q_Q29 1004 146 147 Qp 1.0
Q_Q3 112 101 113 Qp 2
Q_Q30 105 148 149 Qn 1
Q_Q31 1003 146 150 Qn 1
Q_Q32 106 151 149 Qp 1
Q_Q33 1004 152 153 Qp 1.01
Q_Q34 153 104 154 Qp 4
Q_Q35 147 104 155 Qp 4
Q_Q36 150 103 156 Qn 4
Q_Q37 105 157 158 Qn 1
Q_Q38 159 159 160 Qp 1
Q_Q39 106 157 109 Qp 1
Q_Q4 101 101 114 Qp 2
Q_Q40 161 162 109 Qp 2
Q_Q41 102 164 109 Qp 1
Q_Q42 101 164 158 Qn 1
Q_Q43 159 165 158 Qn 2
Q_Q44 161 161 166 Qn 1
Q_Q45 158 103 167 Qn 2
Q_Q46 115 101 111 Qp 2
Q_Q49 1004 168 169 Qp 1.0
Q_Q5 1004 117 116 Qp
Q_Q50 168 170 171 Qn 1
Q_Q51 1004 169 172 Qp 1
Q_Q52 172 1004 174 Qp 1
Q_Q53 1004 1004 175 Qp 1
Q_Q54 176 177 178 Qn 1
Q_Q55 170 170 177 Qn 2
Q_Q56 179 170 180 Qn 1
Q_Q57 177 180 1004 Qn 1
Q_Q58 180 177 181 Qn 2
Q_Q59 1003 176 179 Qn 1
Q_Q6 1004 119 115 Qp 2
Q_Q60 182 172 179 Qn 1
Q_Q61 182 183 184 Qp 1
Q_Q62 183 183 185 Qp
Q_Q63 186 182 183 Qp
Q_Q64 186 103 187 Qn
Q_Q65 103 103 188 Qn
Q_Q66 1003 186 103 Qn
Q_Q67 189 103 190 Qn
Q_Q68 104 104 191 Qp
Q_Q69 189 104 192 Qp
Q_Q7 1003 112 118 Qn 2
Q_Q70 1004 189 104 Qp 1
Q_Q8 118 102 120 Qn 2
Q_Q9 119 102 121 Qn 2
R_R1 1003 111  252  
R_R10 122 1004  500  
R_R11 112 119  24  
R_R117 135 1003  252  
R_R118 137 1003  250  
R_R119 138 1003  500  
R_R12 125 124  40  
R_R13 128 127  40  
R_R14 129 1003  492  
R_R15 130 1003  492  
R_R16 1004 131  492  
R_R2 1003 113  250  
R_R20 132 134  40  
R_R21 1007 133  2  
R_R22 1007 139  2  
R_R23 141 140  40  
R_R24 143 1004  250  
R_R25 144 1004  250  
R_R26 145 1004  500  
R_R27 142 136  24  
R_R28 148 147  40  
R_R29 150 151  40  
R_R3 1003 114  500  
R_R30 154 1003  492  
R_R31 155 1003  492  
R_R32 1004 156  492  
R_R33 126 149  200  
R_R34 110 1003  585  
R_R36 1003 160  800  
R_R37 1005 1003  60k  
R_R38 163 162  200  
R_R39 163 1006  2.5003k  
R_R4 115 107  40  
R_R40 163 1007  2.5000k  
R_R41 157 1005  200  
R_R42 164 1005  200  
R_R43 1004 166  800  
R_R44 1004 167  500  
R_R45 1005 1004  60k  
R_R46 163 165  200  
R_R5 1006 108  2  
R_R58 1008 169  6k  
R_R59 1008 1003  20k  
R_R6 1006 116  2  
R_R60 1003 174  1k  
R_R61 1003 175  1k  
R_R62 176 1004  15.8k  
R_R63 1003 168  33.5k  
R_R64 1004 171  8k  
R_R65 1004 178  250  
R_R66 170 1003  84k  
R_R67 1003 184  2k  
R_R68 1004 181  1150  
R_R69 1004 180  5.4k  
R_R7 117 118  40  
R_R70 185 1003  2k  
R_R71 187 1004  2k  
R_R72 188 1004  2k  
R_R73 190 1004  1960  
R_R74 1003 191  2k  
R_R75 1003 192  2k  
R_R8 120 1004  250  
R_R9 121 1004  250  
V_V33 1002 152 100uV
.ENDS LMH6551
