* LMV881
*****************************************************************************
* (C) Copyright 2012 Texas Instruments Incorporated. All rights reserved.
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers make no warranties, either expressed
** or implied, with respect to this model, including the warranties of
** merchantability or fitness for a particular purpose.  The model is
** provided solely on an "as is" basis.  The entire risk as to its quality
** and performance is with the customer.
*****************************************************************************
*
** Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part: LMV881
* Date: 2/8/2012
* Model Type: All In One
* Simulator: NGspice
* Simulator Version: 23
* EVM Order Number: N/A
* EVM Users Guide: N/A
* Datasheet: SNOSC62A, February 3, 2012
*
* Model Version: 2.2
*
*****************************************************************************
*
* Updates:
*
* Version 1.0 : Release to Web
* Version 2.0 : Release to Web
* Version 2.2 : Release to Web
*****************************************************************************
* Notes: LMV881: SPICE BEHAVIORAL MODEL FOR PRECISION AMPLIFIR LMV881
*****************************************************************************
.SUBCKT LMV881 VINP VINN VDD VSS VOUT SDB
*==========================================================================================================
*
EADDTCOFFSET VINP VINPTCO TCVOS 0 1
EADDNOISE VINPTCO VTCNO VNO1 0 1
*BEVCR1  VOUT  3VCR  V=(I(VSENSE1)*100E6*V(SDB2,0))
*VSENSE1 3VCR  0  DC 0V
*ADDING NOISE
INSA1 0 133 DC 1E-6
INSA2 0 134 DC 1E-6
DNSA1 133 0 DEQIN
DNSA2 134 0 DEQIN
ENSA  VNO1 0 133 134 1
* MODELING TEMPERATURE COEFFICIENTS OF "VOFFSET"
I_ITH1  0 NTHERM1 DC 1E-6
I_ITH2  0 NTHERM2 DC 1E-6
D_DTHERMAL1  NTHERM1 0 DIODEIDEAL
D_DTHERMAL2  NTHERM2 0 DIODEIDEAL
D_DTHERMAL3  NTHERM2 0 DIODEIDEAL
E_ETCNVRSN1  NTHERM3 0 NTHERM1 NTHERM2 1.67386293783563E4
V_VTEMP1     NTHERM4 0 273
E_ETCNVRSNa  TEMPSNS 0 NTHERM3 NTHERM4 1
E_ETCNVRSNb  TCIbias 0 NTHERM3 NTHERM4 1
ETEMPSENSE TCVOS 0 TEMPSNS VTMP 0.7E-6
V100 VTMP 0 27
* INPUT IMPEDENCE STAGE
E_E2U1 N1_1 0 VN1 0 0.5
R_IMP1 VTCNOx VTCNO 72
R_IMP2 VINNx VINN 72
V_V1U1 VP1 VTCNOx {70E-6/2}
V_V2U1 VN1 VINNx {-70E-6/2}
I_I1U1 0 VP1 DC {0.1E-12}
I_I2U1 0 VN1 DC {0.1E-12}
I_I3U1 VP1 VN1 DC {1E-12/2}
C_C1U1 VN1 VP1  {15E-12}
C_C2U1 VP1 0 {5E-12}
C_C3U1 VN1 0 {5E-12}
E_E1U1 VCM1 N1_1 VP1 0 0.5
* Quiescent current
I_I10U1 VDD VSS DC 200E-12
GPNQU1 VDD VSS ENHYS 0 0.95E-3
* New CMVR Logic
E1_INU9 VPQ 0 VINP 0 1
E2_INU9 VNQ 0 VINN 0 1
RIN1 VPQ VCM 1E6
RIN2 VNQ VCM 1E6
ECM1 VCMO 0 VCM 0 1
ECOMP1 N1U9 0 VCMO VDDLIM 10E3
RCOMP1 N1U9 COMPOUT1 1k
D1_COMP1 COMPOUT1 VDDINT1 DIODEIDEAL
D2_COMP1 VSSINT1 COMPOUT1 DIODEIDEAL
V_VDLIM VDDINT1 VDDLIM DC=1.1
ECOMP2 N1U10 0 VSSLIM VCMO 10E3
RCOMP2 N1U10 COMPOUT2 1k
D1_COMP2 COMPOUT2 VDDINT1 DIODEIDEAL
D2_COMP2 VSSINT1 COMPOUT2 DIODEIDEAL
V_VSLIM VSSLIM VSSINT1 DC=-0.2
*Switches
S1VDD VDDINT1 VOUTx1 CMP1 0 S1VDD_mod
S2VSS VSSINT1 VOUTx2 CMP2 0 S2VSS_mod
BCMP1 CMP1 0 V=V(COMPOUT1) < 0 ? 0 : V(COMPOUT1)
BCMP2 CMP2 0 V=V(COMPOUT2) < 0 ? 0 : V(COMPOUT2)
Rx1 VOUTx1 VOUT 0.6m
Rx2 VOUTx2 VOUT 0.6m
.MODEL S1VDD_mod SW RON=0.0001  ROFF=100E9  VT=1.0 VH=0.2
.MODEL S2VSS_mod SW RON=0.0001  ROFF=100E9  VT=1.0 VH=0.2
* CMRR
E_E1U3 N2_1U3 0 VCM1 0  {1e6/44668.35}
R_R1U3 N2_1U3 N2_2U3 1e6
C_C1U3 N2_1U3 N2_2U3 {1/(6.28*1e6*3E3)}
R_R2U3 N2_2U3 0 1.0
G_G1U3 CMRROUT 0 VP1 VN1 -1
G_G2U3 CMRROUT 0 N2_2U3 0  -1
R_R3U3 CMRROUT 0 1
* PSRR POSITIVE
E_E1U4 N2_1U4 0 VDD 0  {1e6/44668.35}
R_R1U4 N2_1U4 N2_2U4 1e6 ac=(1e6)
C_C1U4 N2_1U4 N2_2U4 {1/(6.28*1e6*316.22)}
R_R2U4 N2_2U4 0 1
G_G2U4 VPOLE2 0 N2_2U4 0  -1
* PSRR NEG1
E_E1U90 N2_1U9 0 VSS 0  {1e6/44668.35}
R_R1U90 N2_1U9 N2_2U9 1e6 ac=(1e6)
C_C1U90 N2_1U9 N2_2U9 {1/(6.28*1e6*316.22)}
R_R2U90 N2_2U9 0 1
G_G2U90 VPOLE2 0 N2_2U9 0  -1
* PSRR NEG2
*E_PSINN   NPSRRNEG1 0 VSS 0 1
*C_SUPN    NPSRRNEG1 NPSRRNEG2  10E-3
*R_SUPN    NPSRRNEG2 0  1E15
*G_PSN     NPSRRNEG4 0 NPSRRNEG2 0 7.08E-8
*R_PSN1    NPSRRNEG3 NPSRRNEG4  10E3
*R_PSN2    NPSRRNEG3 0 316
*L_PSN1    NPSRRNEG3 NPSRRNEG4  159E-3
*BE_SUMPS  VPOLE2 0 V=V(NPSRRNEG4)
* GAIN, GBW and SLEWRATE STAGE
E_E1U5 VP1U5 0 CMRROUT 0 1
E_E2U5 VN1U5 0 0 0 1
BG_G1U5 0 VP2U5 I=(V(VP1U5,VN1U5) < {12.1E6/(6.28*23E6)})? (V(VP1U5,VN1U5) > {-16.7E6/(6.28*23E6)} ?
+ V(VP1U5,VN1U5) : {-16.7E6/(6.28*23E6)}) : {12.1E6/(6.28*23E6)}
R_R1U5 VP2U5 0 {316.22E3} ac={316.22E3}
C_C1U5 VP2U5 0 {1/(6.28*23E6)}
R_R2U5 VP2U5 VGGBWSR 0.1u
V_BV20 VDDN3_10 0 DC=0.705
EV_V20 VDDINT1 N3_10 VDDN3_10 0 1
D1x VGGBWSR N3_10 DIODEIDEAL
D2x N3_11 VGGBWSR DIODEIDEAL
V_BV30 N3_11VSS 0 DC=0.705
EV_V30 N3_11 VSSINT1 N3_11VSS 0 1
*Using VCR instead of switch
BVCR2  VP2U5 AGVCR  V=(I(VSEN2)*1E6*V(VSHDN,0))
VSEN2 AGVCR  VSSINT1  DC 0V
* POLE2 OF THE AMPLIFIER
G_G1U6 VPOLE2 0 VGGBWSR 0 -1
R_R1U6 VPOLE2 0 1
C_C1U6 VPOLE2 0 {1/(6.28*2.3*23E6)}
*** OUTPUT STAGE ***
D_D4U7 N5_4 N5_5 DIODEIDEAL
E_E2U7 N5_7 N5_6 N5_5 0 1
V_BEVDD VDDN5_2 0 DC={5E-3+0.72}
EV_V2U7 VDDINT1 N5_2 VDDN5_2 0 1
D_D5U7 N5_7 N5_5 DIODEIDEAL
H_Hx N5_6 0 V_Vlmt {-0.81/70E-3}
D_D6U7 N5_5 N5_7 DIODEIDEAL
E_E1U7 N5_1 0 VPOLE2 0  1
R_R1U7 N5_1 N5_5  {8.5}
V_BV_V3U7 N5_4IN 0 DC={5E-3+0.72}
EV_V3U7 N5_4 VSSINT1 N5_4IN 0 1
D_D3U7 N5_5 N5_2 DIODEIDEAL
V_Vlmt N5_5 VOUT 0
*** SUPPLY_RAIL_CURRENT ***
G_G10U7 15 0 N5_1 N5_5 {1/8.5}
G_G20U7 0 16 N5_1 N5_5 {-1/8.5}
D_D30U7 0 15 DZ
D_D40U7 16 0 DZ
D_D50U7 VDD 15 DIODEIDEAL
D_D60U7 16 VSSINT1 DIODEIDEAL
*** SHUTDOWN Functionality ***
EVSSINT VSSINT1 0 VSS 0 1
EVDDINT VDDINT1 0 VDD 0 1
R1U8 VDDINT1 VDDINT2 1E-6
BESUPREF1 VSUPPLUS 0 V = (V(VDDINT2) < 5.5 ? V(VDDINT2) : 5.5 )
BESUPREF2 VSUPMINUS 0 V = (V(VSSINT1) > -2.701 ? V(VSSINT1) : -2.7 )
R2U8 ENHYS EN 1k
C2U8 EN 0 1.64n IC=1.8
C3U8 Node1 0 1.08n
S1x EN Node1 VL55 0 S1x_mod
BEVL50 VL55  0 V=((V(VSUPPLUS)-V(VSSINT1))>4.95) ? 0 : 5
BESHDN1 shd1 0 V=(V(EN)>0.890) ? 1 : 0
BESHDN2 shd2 0 V=((V(VDDINT1) - V(VSSINT1)) > 2.699) ? 1 : 0
BESHDN3 shd3 0 V=((V(VDDINT1) - V(VSSINT1)) < 5.501) ? 1 : 0
BESHDN VSHDN 0 V=((V(shd1)*V(shd2)*V(shd3))>0.9) ? 1.8 : 0
BESDOB VSDOB 0 V =(V(VSHDN) > 0.9) ? 0 : 1.8
* NEW HYS BLOCK
B3HYS SDBINT 0 V=(V(SDB)-V(VSS))
B4HYS INVINT 0 V=(0.972+V(VSS))
B2HYS HYS SDBINT V = V(ENHYS) > 0.9 ? 300m : 0
B1HYS 4HYS 0 V = V(HYS,INV) > 0  ?  1.8  :  0m
ROHYS 4HYS ENHYS 1
COHYS ENHYS 0 1E-12
VREF INV 0 DC=0.972
* PARAMETER AND MODEL DEFINITION
.param NF=0.1515
.MODEL DEQIN D KF=3e-016  AF=1
.MODEL DIODEIDEAL D IS=1e-14
.MODEL S10x_mod SW RON=0.0001  ROFF=100E9  VT=1.0 VH=0.2
.MODEL S20x_mod SW RON=0.0001  ROFF=100E9  VT=1.0 VH=0.2
.MODEL SREDUCE_DCGAIN_modt SW ROFF=100E6 RON=0.1 VH=0.2V VT=1.0V
.MODEL DZ D IS=1E-15 BV=50
.MODEL S1x_mod SW RON=0.0001  ROFF=100E9  VT=1.5 VH=0.5
.MODEL SVOUT_mod SW RON=100E6 ROFF=0.1 VH=0.2V VT=1.0V
* NODESET CONDITIONS
.NODESET V(VCM1)=1.05 V(N2_1U3)=23 V(N2_2U3)=2.3E-5 V(VDDN3_10)=0.7
.NODESET V(N5_5)=1.0 V(VOUT)=1.0
.ends LMV881