/*
 * loader.c
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2005
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "decode.h"
#include "loader.h"

/******************************************************************************
 * loaderPrime
 ******************************************************************************/
int loaderPrime(LoaderState *statep, char **framePtr)
{
    int numBytes;

    /* Read a full 'window' of encoded data */
    numBytes = read(statep->inputFd, statep->readBuffer, statep->readSize);

    if (numBytes == -1) {
        ERR("Error reading data from video file [%s]\n",strerror(errno));
        return FAILURE;
    }

    /* Initialize the state */
    statep->curPtr = statep->readBuffer;
    statep->readPtr = statep->readBuffer + numBytes;

    *framePtr = statep->curPtr;
    statep->firstFrame = TRUE;
    statep->endClip = FALSE;

    return SUCCESS;
}

/******************************************************************************
 * loaderGetFrame
 ******************************************************************************/
int loaderGetFrame(LoaderState *statep, int frameSize, char **framePtr)
{
    int   numBytes;
    int   dataLeft;
    int   spaceLeft;
    char *endBuf;

    statep->firstFrame = FALSE;
    statep->curPtr += frameSize;

    dataLeft = statep->readPtr - statep->curPtr;
    if (dataLeft <= 0) {
        /* End of file */
      //        while (!gblGetQuit() && !gblAllDone(statep->doneMask)) {
      //      usleep(PAUSE);
      //  }

        gblResetDone(statep->doneMask);

        if (statep->loop) {
            /* Restart at beginning of file */
            statep->endClip = TRUE;

            if (lseek(statep->inputFd, 0, SEEK_SET) == -1) {
                ERR("Failed lseek on file (%s)\n", strerror(errno));
                return FAILURE;
            }
        }
        else {
            gblSetQuit();
        }
    }
    else {
        endBuf = statep->readBuffer + statep->readBufSize;
        spaceLeft = endBuf - statep->curPtr;

        if (spaceLeft < statep->readSize) {
            /* Could not fit 'window', start over at beginning of buffer */
            memcpy(statep->readBuffer, statep->curPtr, dataLeft);
            statep->curPtr = statep->readBuffer;
            statep->readPtr = statep->readBuffer + dataLeft;
        }

        if (dataLeft == (statep->readSize - frameSize)) { 
            /* Incremental read making full we have a full 'window' */
            numBytes = read(statep->inputFd, statep->readPtr, frameSize);

            if (numBytes == -1) {
                ERR("Error reading data from file (%s)\n", strerror(errno));
                return FAILURE;
            }

            statep->readPtr += numBytes;
        }

        *framePtr = statep->curPtr;
    }

    return SUCCESS;
}


