/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fsi;

/**
 *
 * @author a0225962
 */
public class FSICore {
    
    public static FSIExecutionPoint CalculateSingleLineExecutionPoint(boolean [][] data)
    {
        int xLengthOfData = data[0].length;
        int yLengthOfData = data.length;
        
        System.out.println(
                "Data Size: " + String.valueOf(xLengthOfData) + ", "
                + String.valueOf(yLengthOfData));
        
        int[] xIntercepts = new int[2];
        int xNumberOfIntercepts = 0;
        
        boolean previousValue = false;
        for (int x = 0; x < xLengthOfData; x++)
        {
            boolean currentValue = data[0][x];
            if (previousValue != currentValue)
            {
                xIntercepts[xNumberOfIntercepts] = x;
                xNumberOfIntercepts++;
            }
            previousValue = currentValue;
        }
        
        System.out.println("Number of X Intercepts: " 
                + String.valueOf(xNumberOfIntercepts));
        System.out.println("X-Intercepts: " 
                + String.valueOf(xIntercepts[0]) + ", "
                + String.valueOf(xIntercepts[1]));
        
        int[] yIntercepts = new int[2];
        int yNumberOfIntercepts = 0;
        
        previousValue = false;
        for (int y = 0; y < yLengthOfData; y++)
        {
            boolean currentValue = data[y][0];
            if (previousValue != currentValue)
            {
                yIntercepts[yNumberOfIntercepts] = y;
                yNumberOfIntercepts++;
            }
            previousValue = currentValue;
        }
        
        System.out.println("Number of Y Intercepts: " 
                + String.valueOf(yNumberOfIntercepts));
        System.out.println("Y-Intercepts: " 
                + String.valueOf(yIntercepts[0]) + ", "
                + String.valueOf(yIntercepts[1]));
        
        FSIExecutionPoint executionPoint = null;
        
        if (xNumberOfIntercepts == 2 && yNumberOfIntercepts ==2
                && xIntercepts[0] == yIntercepts[0]
                && xIntercepts[0] == 0)
        {
            //Scenario 1 Passes through the center
            System.out.println("Scenario 1, Data passes through the center");
            int passRangeWidth = xIntercepts[1] + yIntercepts[1];
            int xval = xIntercepts[1] - (int)(passRangeWidth/2);
            int yval = 0;
            if (xval < 0)
            {
                int offset = 0 - xval;
                yval = yval + offset;
                xval = xval + offset;
            }
            executionPoint = 
                    new FSIExecutionPoint(xval, yval);
                        
        }
        else if (xNumberOfIntercepts == 2 && yNumberOfIntercepts == 0)
        {
            //Scenatio 2 Passes through the x-axis twice
            System.out.println("Scenario 2, Data passes through the x-axis twice");
            int passRangeWidth = xIntercepts[1] - xIntercepts[0];
            executionPoint = new FSIExecutionPoint(
                    xIntercepts[0] + (int)(passRangeWidth/2), 0);
            
        }
        else if (xNumberOfIntercepts == 1 && yNumberOfIntercepts == 0)
        {
            System.out.println("Scenario 3, Data passes through the x-axis once"
            + " at the right corner!");
            int passRangeWidth = 31 - xIntercepts[0];
            executionPoint = new FSIExecutionPoint(
                    xIntercepts[0] + (int)(passRangeWidth/2), 0);
        }
        else if (xNumberOfIntercepts == 0 && yNumberOfIntercepts == 2)
        {
            System.out.println("Scenario 4, Data passes through the y-axis twice");
            int passRangeWidth = yIntercepts[1] - yIntercepts[0];
            executionPoint = new FSIExecutionPoint(
                    0, yIntercepts[0] + (int)(passRangeWidth/2));
        }
        else if (xNumberOfIntercepts == 0 && yNumberOfIntercepts == 1)
        {
            System.out.println("Scenario 5, Data passes through the y-axis once"
            + " at the top corner!");
            int passRangeWidth = 31 - yIntercepts[0];
            executionPoint = new FSIExecutionPoint(
                    0, yIntercepts[0] + (int)(passRangeWidth/2));
        }
        else if (xNumberOfIntercepts == 1 && yNumberOfIntercepts == 2
                && xIntercepts[0] == 0)
        {
            System.out.println("Scenario 6, x-axis all pass. y-axis crossed.");
            int passRangeWidth = 32 + yIntercepts[1];
            executionPoint = new FSIExecutionPoint(32 - passRangeWidth/2, 0);
        }
        else if (xNumberOfIntercepts == 2 && yNumberOfIntercepts == 1
                && yIntercepts[0] == 0)
        {
            System.out.println("Scenario 7, y-axis all pass. x-axis crossed.");
            int passRangeWidth = 32 + xIntercepts[1];
            executionPoint = new FSIExecutionPoint(0, 32 - passRangeWidth/2);
        }
        else if (xNumberOfIntercepts == 1 && yNumberOfIntercepts == 1
                && xIntercepts[0] == 0 && yIntercepts[0] == 0)
        {
            System.out.println("Scenario 8, the whole data set passes!");
            executionPoint = new FSIExecutionPoint(0, 0);
        }
        else
        {
            System.out.println("Unknown state!");
        }
        
        if (executionPoint != null)
        {
            System.out.println("Selected execution point: " 
                + String.valueOf(executionPoint.RX0Delay) + ", "
                + String.valueOf(executionPoint.CLKDelay));
            return executionPoint;
        }
        
        
        return null;
        
    }
    
    
    public static RX1vsCLKCollection GenerateSingleLineRX1vsCLKArray(boolean [][][] data, FSIExecutionPoint singleLineExePoint)
    {
        boolean [][] clkShiftedToZerovsrx1Array = new boolean [32 - singleLineExePoint.CLKDelay][32];
        int clk = singleLineExePoint.CLKDelay;
        for (int rx0 = singleLineExePoint.RX0Delay; rx0 < 32; rx0++)
        {
            if (clk < 32)
            {
                for (int rx1 = 0; rx1 < 32; rx1++)
                {
                    if (data[clk][rx0][rx1])
                    {
                        clkShiftedToZerovsrx1Array[clk - singleLineExePoint.CLKDelay][rx1] = true;
                    }
                    else
                    {
                        clkShiftedToZerovsrx1Array[clk - singleLineExePoint.CLKDelay][rx1] = false;
                    }
                }
            }
            else
            {
                break;
            }
            clk++;
        }
        
        return new RX1vsCLKCollection(clkShiftedToZerovsrx1Array, singleLineExePoint);
    }
    
    public static FSIExecutionPoint CalculateDualLineExecutionPoint(RX1vsCLKCollection rx1vsclk)
    {
        FSIExecutionPoint singleLineExePoint = rx1vsclk.rx0clkExecutionPoint;
        FSIExecutionPoint unadjustedPoint = CalculateSingleLineExecutionPoint(rx1vsclk.GetRawData());
        
        int offset = unadjustedPoint.CLKDelay;
        
        FSIExecutionPoint executionPoint = new FSIExecutionPoint(
                rx1vsclk.rx0clkExecutionPoint.RX0Delay + offset,
                unadjustedPoint.RX0Delay,
                rx1vsclk.rx0clkExecutionPoint.CLKDelay + offset);
        
        return executionPoint;
    }
    
}
