/**************************************************************************************************
  Filename:       hal_key.h
  Revised:        $Date: 2007-07-06 10:42:24 -0700 (Fri, 06 Jul 2007) $
  Revision:       $Revision: 13579 $

  Description:    This file contains the interface to the KEY Service.


  Copyright 2005-2007 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer (which must be your employer)
  and Texas Instruments Incorporated (the "License").  You may not use this
  Software unless you agree to abide by the terms of the License. The License
  limits your use, and you acknowledge, that the Software may not be modified,
  copied or distributed unless embedded on a Texas Instruments microcontroller
  or used solely and exclusively in conjunction with a Texas Instruments radio
  frequency transceiver, which is integrated into your product.  Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, 
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE, 
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com. 
**************************************************************************************************/

#ifndef HAL_CAPSENSE_H
#define HAL_CAPSENSE_H

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************************************
 *                                             INCLUDES
 **************************************************************************************************/
#include "hal_board.h"

/**************************************************************************************************
 *                                            CONSTANTS
 **************************************************************************************************/

#define HAL_CAPSENSE_NOF_BTNS                 5 // Number of defined buttons
#if ( HAL_CAPSENSE_NOF_BTNS > 0x80 )
#error "Number of buttons defined exceeds limits"
#elif ( HAL_CAPSENSE_NOF_BTNS > 0x10 )
#warning "Number of buttons defined exceeds a 2-byte mask for buttons"
#endif

#define HAL_CAPSENSE_DEBOUNCE_VALUE_SHORT     61  // Debounce confidently 3 or more measurements
#define HAL_CAPSENSE_DEBOUNCE_VALUE_LONG     333  // Long debounce, suitable for 
#define HAL_CAPSENSE_RESET_PERIOD            666  // Reset period, e.g. after last touch, or debounce. 
#define HAL_CAPSENSE_POLLING_VALUE            32  // Measure every 16ms (to avoid timer overflow this should be less than 0xFFFF/tickSpeed)
#define HAL_CAPSENSE_NOF_SETTLING_ITERATIONS   0  // Necessary if tracking does NOT implement +-1 for |delta|/k < 1.
  // POLL INTERVAL MODES
#define HAL_CAPSENSE_MODE_UP                  0x33
#define HAL_CAPSENSE_MODE_DOWN                (~HAL_CAPSENSE_MODE_UP)

 // Button mapping. Max 16 buttons, due to bitmasking
#define HAL_CAPSENSE_BTN0                     0x0001
#define HAL_CAPSENSE_BTN1                     0x0002
#define HAL_CAPSENSE_BTN2                     0x0004
#define HAL_CAPSENSE_BTN3                     0x0008
#define HAL_CAPSENSE_BTN4                     0x0010
#define HAL_CAPSENSE_NO_BTN                   0x0000
#define HAL_CAPSENSE_NO_BTN_IDX                 0xFF

#if defined (HAL_BOARD_CC2531STBFP)
  // Button mapping, can be or'd together
#define HAL_CAPSENSE_STDBY             HAL_CAPSENSE_BTN0
#define HAL_CAPSENSE_VOL_UP            HAL_CAPSENSE_BTN1
#define HAL_CAPSENSE_VOL_DOWN          HAL_CAPSENSE_BTN2
#define HAL_CAPSENSE_CHAN_DOWN         HAL_CAPSENSE_BTN3
#define HAL_CAPSENSE_CHAN_UP           HAL_CAPSENSE_BTN4
#endif

// Which buttons are defined for mode DOWN.
#define HAL_CAPSENSE_MODE_DOWN_MASK     (BIT0 | BIT2 | BIT3)
#define HAL_CAPSENSE_MODE_UP_MASK       (~(HAL_CAPSENSE_MODE_DOWN_MASK))

#if ((defined RF_STATS_RX) && (RF_STATS_RX == TRUE)) || ((defined RF_STATS_TX) && (RF_STATS_TX == TRUE))
#define RF_STATS_CONTINUE_CONDITION           0x00
#define RF_STATS_START_CONDITION              0x01
#define RF_STATS_END_CONDITION                0x02
#define RF_STATS_LEN                          86
#define RF_STATS_HDR_LEN                      2
#define RF_STATS_LEN_BYTE_IDX                 0x00
#define RF_STATS_CMD_BYTE_IDX                 0x01
#define RF_STATS_CMD_BYTE_CAPSENSE            0x00
#define RF_STATS_DATA_BYTE_IDX                0x02
extern uint8 zidDongleTaskId;
#else
#define RF_STATS_CONTINUE_CONDITION           0x00
#define RF_STATS_START_CONDITION              0x00
#define RF_STATS_END_CONDITION                0x00
#endif //((defined RF_STATS_RX) && (RF_STATS_RX == TRUE)) || ((defined RF_STATS_TX) && (RF_STATS_TX == TRUE))

/**************************************************************************************************
 * MACROS
 **************************************************************************************************/

#define HAL_CAPSENSE_T1CTL_CH2IF                       0x80
#define HAL_CAPSENSE_T1CTL_CH1IF                       0x40
#define HAL_CAPSENSE_T1CTL_CH0IF                       0x20
#define HAL_CAPSENSE_T1CTL_OVFIF                       0x10
#define HAL_CAPSENSE_T1CTL_DIV                         0x0C
#define HAL_CAPSENSE_T1CTL_MODE                        0x03
#define HAL_CAPSENSE_T1CTL_MODE_FREERUN                0x01    // Free Running mode
  
#define HAL_CAPSENSE_T1CCTL0_IM                        0x40    // Timer 1,Channel 0 Interrupt mask
#define HAL_CAPSENSE_T1CCTL1_IM                        0x40    // Timer 1,Channel 1 Interrupt mask
#define HAL_CAPSENSE_T1CCTL2_IM                        0x40    // Timer 1,Channel 2 Interrupt mask
#define HAL_CAPSENSE_T1CCTL3_IM                        0x40    // Timer 1,Channel 3 Interrupt mask
#define HAL_CAPSENSE_T1CCTL4_IM                        0x40    // Timer 1,Channel 4 Interrupt mask
  
#define HAL_CAPSENSE_T3CCTL0_IM                        0x40    // Timer 3,Channel 0 Interrupt mask
#define HAL_CAPSENSE_T3CCTL1_IM                        0x40    // Timer 3,Channel 1 Interrupt mask

// P2DIR (0xFF) - Port 2 Direction
#define HAL_CAPSENSE_P2DIR_PRIP0                       0xC0
#define HAL_CAPSENSE_P2DIR_PRIP0_2                     (0x02 << 6)

// P2SEL (0xF5) - Port 2 Function Select
#define HAL_CAPSENSE_P2SEL_PRI1P1                      0x10
#define HAL_CAPSENSE_P2SEL_PRI0P1                      0x08
  
// P1SEL (0xF5) - Port 1 Function Select
#define HAL_CAPSENSE_P1SEL_PRI1P1                      0x10
#define HAL_CAPSENSE_P1SEL_PRI0P1                      0x08
  
// T1CCTL1 (0xE5) - Timer 1 Channel 0 Capture/Compare Control   
#define HAL_CAPSENSE_T1CCTL0_MODE                      0x04    // Capture or compare mode
#define HAL_CAPSENSE_T1CCTL0_CAP                       0x03
#define HAL_CAPSENSE_T1C0_RISE_EDGE                    (0x01)    // Capture on rising edge
#define HAL_CAPSENSE_T1C0_FALL_EDGE                    (0x02)    // Capture on falling edge
  
// T1CCTL1 (0xE6) - Timer 1 Channel 1 Capture/Compare Control  
#define HAL_CAPSENSE_T1CCTL1_MODE                      0x04    // Capture or compare mode  
#define HAL_CAPSENSE_T1CCTL1_CAP                       0x03
#define HAL_CAPSENSE_T1C1_RISE_EDGE                    (0x01)    // Capture on rising edge
#define HAL_CAPSENSE_T1C1_FALL_EDGE                    (0x02)    // Capture on falling edge

// T1CCTL2 (0xE7) - Timer 1 Channel 2 Capture/Compare Control
#define HAL_CAPSENSE_T1CCTL2_MODE                      0x04    // Capture or compare mode
#define HAL_CAPSENSE_T1CCTL2_CAP                       0x03
#define HAL_CAPSENSE_T1C2_RISE_EDGE                    (0x01)    // Capture on rising edge
#define HAL_CAPSENSE_T1C2_FALL_EDGE                    (0x02)    // Capture on falling edge

// T1CCTL2 (0xE8) - Timer 1 Channel 3 Capture/Compare Control
#define HAL_CAPSENSE_T1CCTL3_MODE                      0x04    // Capture or compare mode
#define HAL_CAPSENSE_T1CCTL3_CAP                       0x03
#define HAL_CAPSENSE_T1C3_RISE_EDGE                    (0x01)    // Capture on rising edge
#define HAL_CAPSENSE_T1C3_FALL_EDGE                    (0x02)    // Capture on falling edge
  
// T1CCTL2 (0xE9) - Timer 1 Channel 4 Capture/Compare Control
#define HAL_CAPSENSE_T1CCTL4_MODE                      0x04    // Capture or compare mode
#define HAL_CAPSENSE_T1CCTL4_CAP                       0x03
#define HAL_CAPSENSE_T1C4_RISE_EDGE                    (0x01)    // Capture on rising edge
#define HAL_CAPSENSE_T1C4_FALL_EDGE                    (0x02)    // Capture on falling edge
  
  
#define HAL_CAPSENSE_T1CTL_DIV_8                       (0x01 << 2) // Divide tick frequency by 8
  
  // PERCFG (0xF1) - Peripheral Control. Timer 1
#define HAL_CAPSENSE_PERCFG_T1CFG                      0x40
    
/**************************************************************************************************
 * TYPEDEFS
 **************************************************************************************************/
typedef void (*halCapSenseCBack_t) (uint16 buttons );

/**************************************************************************************************
 *                                             GLOBAL VARIABLES
 **************************************************************************************************/

/**************************************************************************************************
 *                                             FUNCTIONS - API
 **************************************************************************************************/

/*
 * Initialize the CapSense Service
 */
extern void HalCapSenseInit( void );

/*
 * Configure the CapSense Service
 */
extern void HalCapSenseConfig (halCapSenseCBack_t cback);

/*
 * Allow application to reset the HalCapSense module
 */
extern void halCapSenseReset ( void );

/*
 * This is for internal use, used by hal_driver
 */
extern void HalCapSensePoll ( void );

/**************************************************************************************************
**************************************************************************************************/

#ifdef __cplusplus
}
#endif

#endif //HAL_CAPSENSE_H
