**TPLH/HL-LZ/ZL-HZ/ZH AC analysis for nominal process(avca164245)
************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE :February, 2000. 
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-8     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-8
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
    .OPTIONS GSHUNT=1E-8
***********************************************************************
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      AVCA164245INC.INC       (netlist)
*        X_PROCESS_SELECTOR 0 NOMINALINC
*	.include res_nominal
*        X_PROCESS_SELECTOR 0 WEAKINC
*	.include res_weak
*        X_PROCESS_SELECTOR 0 STRONGINC
*	.include res_strong
*.include out
*.include weak_final
*.include res_weak
*	 	
***********************************************************************
**** To use this SPICE model, Please select a pair of process models for each 
**** process. Example: for nominal process, select  NOMINALINC and  res_nominal.
**** Select only one package model at a time. To change the package selection,
**** the package model names in the sub circuit need to be changed. 
**** Example: to change TSSOP package from the BGA package,
**** select the .include tssop48.dat and
**** change the models as
**** X_PIN47      p_1a1       s_1a1		TSSOP48_47
***********************************************************************
****
*      .
*      .
*      .
.OPTIONS search='./' 

********* Device Netlist ***********
	X_DEVICE_SELECTOR  0 AVCBH164245INC


************ Package Model ********* 
*	.include tssop48.dat
	.include bga48.dat
*	.include tvsop48.dat

******** Nominal Process Models *******
*        X_PROCESS_SELECTOR 0 NOMINALINC
*	.include res_nominal

******** Weak Process Models *********
*        X_PROCESS_SELECTOR 0 WEAKINC
*	.include res_weak

******** Strong Process Models *********
        X_PROCESS_SELECTOR 0 STRONGINC
	.include res_strong

******** Temperature ***************
.temp 25


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
xavcbh164245  x_1a1  x_1b1 x_noe x_dir x_cvcca x_cvccb x_cgnd avcbh164245 

***********************************************************************
******Supply Voltages
***********************************************************************

v_cvcca         x_cvcca     0     DC    1.8
v_cvccb         x_cvccb     0     DC    1.8
v_cgnd          x_cgnd      0     DC    0.0


***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT avcbh164245 p_1a1 p_1b1 p_noe p_dir p_cvcca p_cvccb p_cgnd 
 X_PIN47      p_1a1       s_1a1		BGA48_47
 X_PIN2       p_1b1       s_1b1      	BGA48_02
 X_PIN48      p_noe       s_1noe        BGA48_48
 X_PIN1       p_dir       s_1dir        BGA48_01
 X_PIN4       p_cgnd      s_cgnd	BGA48_04
 X_PIN10      p_cgnd      s_cgnd	BGA48_10
 X_PIN15      p_cgnd      s_cgnd	BGA48_15
 X_PIN21      p_cgnd      s_cgnd	BGA48_21
 X_PIN28      p_cgnd      s_cgnd	BGA48_28
 X_PIN34      p_cgnd      s_cgnd	BGA48_34
 X_PIN39      p_cgnd      s_cgnd	BGA48_39
 X_PIN45      p_cgnd      s_cgnd	BGA48_45
 X_PIN7       p_cvccb     s_cvccb  	BGA48_07
 X_PIN18      p_cvccb     s_cvccb  	BGA48_18
 X_PIN31      p_cvcca     s_cvcca  	BGA48_31
 X_PIN42      p_cvcca     s_cvcca  	BGA48_42

xavcbh164245 s_1a1 s_1b1 s_1noe s_1dir s_cvcca s_cvccb s_cgnd avcbh164245__bit

.ENDs avcbh164245

***********************************************************************
***********************************************************************
.param capload=50p
.param resload=500
.param resload1=1000
.param biashv=1.8
.param biaslv=0.0
.param supplyv=3.3
.param loadv=6
.param clkenab1=0
.param oeab1=3
.param leab1=0


*V_load            load         0     DC    loadv
***********************************************************************
.TRAN         0.5NS 60NS
.print tran v(x_1b1)
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

 V_dir  x_dir   0     DC      biashv
 V_in   x_1a1   0     PULSE (biaslv  biashv  5NS  1NS  1NS  20NS  40NS)
 V_noe	x_noe	0     DC      0
 R1_LOAD   x_1b1      0   resload1
 C1_LOAD   x_1b1      0   capload

***********************************************************************
*.alter

*V_noe   x_noe   0   PULSE (biaslv  biashv  10NS  1NS  1NS  20NS 40NS)
* V_in	x_1b1	0	DC	0v
* R1_LOAD   x_1a1      0   resload
* C1_LOAD   x_1a1      0   capload
* R2_LOAD   x_1a1      load   resload

*************disable test(z to high & high to z)
*.alter
 
* V_noe   x_noe   0   PULSE (biaslv  biashv  10NS  1NS  1NS  20NS  40NS)
* V_in	x_1b1	0	DC	biashv
* R1_LOAD   x_1a1      0   resload
* C1_LOAD   x_1a1      0   capload
* R2_LOAD   x_1a1      0	 resload


***********************************************************************
***********************************************************************
.END
