//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  July 2012
//  Built with IAR Embedded Workbench Version: 5.4
//******************************************************************************

#include "Config.h"

char StatusLED;
unsigned int count, FrequencyB, FrequencyA, TmpFrequency, AccelTimeBase, AccelPPS;
char StepperIndex, PhaseDutyCycle, Device, Speed;
bool StepperDirection;

void Task0(void)
{
if (MessageComplete)
    {
      SerialOutBuffer[0] = FIRMWARE_REVISION;
      SerialOutBuffer[1] = 0;
      SerialOutBuffer[2] = 0;
      switch(OPCODE)
      {

// Write GPIO Data [ OPCODE = 0 ] [ GPIO DATA ] [ Not Used ] [ Not Used ] [ Not Used ]
// GPIO DATA = P13/P12/P11/P10/P47/P46/P45/P44
      case (WRITE_GPIO):
        P1OUT = SerialBuffer[1];
        P4OUT = SerialBuffer[2];
        SerialOutBuffer[1] = ~SerialBuffer[1];
      break;

// SET Timer Out [ OPCODE = 0x6 ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (SET_TMR_OUT):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL0 |= BIT2;                  // Set OUT
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL1 |= BIT2;                  // Set OUT
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL2 |= BIT2;                  // Set OUT
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL3 |= BIT2;                  // Set OUT
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL4 |= BIT2;                  // Set OUT
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL5 |= BIT2;                  // Set OUT
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL6 |= BIT2;                  // Set OUT
          break;
        }
        break;

// Enable PWM [ OPCODE = 0x07 ] [ Timer # ] [ Duty Cycle ] [ Not Used ] [ Not Used ]
      case (ENABLE_PWM):
        TBCTL |= TB_CNTL_08;                //Configure Timer to run up to FF (8 bit FRC)
        int tempOut;
        
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCR0 = SerialBuffer[2];
            tempOut = TBCCTL0;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL0 = tempOut;
        break;
        case 1:
            TBCCR1 = SerialBuffer[2];
            tempOut = TBCCTL1;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL1 = tempOut;
        break;
        case 2:
            TBCCR2 = SerialBuffer[2];
            tempOut = TBCCTL2;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL2 = tempOut;
        break;
        case 3:
            TBCCR3 = SerialBuffer[2];
            tempOut = TBCCTL3;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL3 = tempOut;
        break;
        case 4:
            TBCCR4 = SerialBuffer[2];
            tempOut = TBCCTL4;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL4 = tempOut;
        break;
        
        }
      break;
// Disable PWM [ OPCODE = 0x08 ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (DISABLE_PWM):

        //(TBCCTL0 + SerialBuffer[1]) &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        }
      break;
// Enable PWM [ OPCODE = 0x09 ] [ Timer # ] [ Duty Cycle ] [ Not Used ] [ Not Used ]
      case (UPDATE_PWM):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCR0 = SerialBuffer[2];
        break;
        case 1:
            TBCCR1 = SerialBuffer[2];
        break;
        case 2:
            TBCCR2 = SerialBuffer[2];
        break;
        case 3:
            TBCCR3 = SerialBuffer[2];
        break;
        case 4:
            TBCCR4 = SerialBuffer[2];
        break;
        case 5:
            TBCCR5 = SerialBuffer[2];
        break;
        case 6:
            TBCCR6 = SerialBuffer[2];
        break;
        }
            break;
            
// Read Memory [Opcode = 0xE0 ] [ Address Hi ] [ Address Lo ] [ Not Used ] [ Not Used ]
      case (READ_MEM):
       int * MyPointer;
       int Address;

       Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
       MyPointer = (int *) Address;
       SerialOutBuffer[1] = (*MyPointer & 0xFF00) >> 8;
       SerialOutBuffer[2] = (*MyPointer & 0xFF);
      break;
// Write Memory [Opcode = 0xE1 ] [ Address Hi ] [ Address Lo ] [ Data Hi ] [ Data Lo ]
      case (WRITE_WMEM):
        int Data;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        Data = (SerialBuffer[3]*256 + SerialBuffer[4]);
        MyPointer = (int *) Address;
        *MyPointer = Data;
        break;

// Write Byte Memory [Opcode = 0xE2 ] [ Address ] [ Address Lo ] [ Data ] [Not Used ]
      case (WRITE_BMEM):
        char BData;
        char * MyPtr;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        BData = SerialBuffer[3];
        MyPtr = (char *) Address;
        *MyPtr = BData;
        break;

      case (RESET_MCU):
        WDTCTL = 0x00;
        break;
      case (SHOW_CLKS):
        P5SEL |= SerialBuffer[1] & 0xF0;
        break;
      }
    MessageComplete = false;
    SerialOutPointer = 0;
    UCA0TXBUF = SerialOutBuffer[SerialOutPointer];
    IE2 |= UCA0TXIE;
    }
}





