//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  July 22, 2010
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

void Task1(void)
{

  switch (AccelerateState)
  {
  case (NOACC):
    break;
  case (ACCEL):
    if (tmpAccelTimeBase > 0)
        {
        tmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if ((unsigned int) Frequency[STEP_TIMER_NUMBER] < (unsigned int)DesiredStepperSpeed)
        {
          Frequency[STEP_TIMER_NUMBER] = DesiredStepperSpeed;
          AccelerateState = NOACC;
        }
        else
        {
          Frequency[STEP_TIMER_NUMBER] -= AccelRate;
        }
        tmpAccelTimeBase = AccelTimeBase;
        }
    break;

  case (DECEL):
    if (tmpAccelTimeBase > 0)
        {
        tmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[STEP_TIMER_NUMBER] + (unsigned int) AccelRate) < DesiredStepperSpeed)
        {
          Frequency[STEP_TIMER_NUMBER] += AccelRate;
        }
        else
        {
          AccelerateState = NOACC;
        }
        tmpAccelTimeBase = AccelTimeBase;
        }
    break;

  case (STOP):
    if (tmpAccelTimeBase > 0)
        {
        tmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[STEP_TIMER_NUMBER] + (unsigned int) AccelRate) < DesiredStepperSpeed)
        {
          Frequency[STEP_TIMER_NUMBER] += AccelRate;
        }
        else
        {
          TBCCTL3 &= 0xFF0F;                                          //Disable CC and Interrupt
          AccelerateState = NOACC;
        }
        tmpAccelTimeBase = AccelTimeBase;
        }
    break;
  }
}
