/*
 *  Copyright 2003 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

/*
 *  ======== evmdm642.c ========
 *  EVMDM642 board initializion implementation.
 */

#include <csl.h>
#include <csl_i2c.h>

#include "evmdm642.h"

/* I2C handle */
I2C_Handle EVMDM642_I2C_hI2C;

/* Initialize the board APIs */
void EVMDM642_init()
{
    volatile Uint32 test;

    I2C_Config i2cCfg = {
        0x0000007f, /* I2COAR -    Not used if master */
        0x00000000, /* I2CIER -    Disable interrupts, use polling */
        0x0000001b, /* I2CCLKL -   Low period for 100KHz operation */
        0x0000001b, /* I2CCLKH -   High period for 100KHz operation */
        0x00000002, /* I2CCNT -    Data words per transmission */
        0x0000001a, /* I2CSAR -    Slave address */
        0x00004680, /* I2CMDR -    Mode */
        0x00000019  /* I2CPSC -    Prescale 300MHz to 12MHz */
    };
        
    /* Initialize CSL */
    CSL_init();
    
    /* Unlock PERCFG through PCFGLOCK */
    *((unsigned long *)0x1b3f018) = 0x10c0010c;
    
    /* Enable VP0-VP2, I2C and McASP0 in PERCFG */
    *((unsigned long *)0x1b3f000) = 0x79;
    
    /* Read back PERCFG */
    test = *((unsigned long *)0x1b3f000);
    
    /* Wait at least 128 CPU cycles */
    EVMDM642_wait(128);

    /* Open I2C handle */
    EVMDM642_I2C_hI2C = I2C_open(I2C_PORT0, I2C_OPEN_RESET);

    /* Configure I2C controller */
    I2C_config(EVMDM642_I2C_hI2C, &i2cCfg);

    /* Take I2C out of reset */        
    I2C_outOfReset(EVMDM642_I2C_hI2C);
}

/* Spin in a delay loop for delay iterations */
void EVMDM642_wait(Uint32 delay)
{
    volatile Uint32 i, n;
    
    n = 0;
    for (i = 0; i < delay; i++)
    {
        n = n + 1;
    }
}



