/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fsigraphs.dualline.trellis;

import fsi.FSICore;
import fsi.FSIExecutionPoint;
import fsi.RX1vsCLKCollection;
import fsigraphs.delaymeasurement.GraphFSIDelayMeasurement_FXMLController;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.print.PrinterJob;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.imageio.ImageIO;

/**
 * FXML Controller class
 *
 * @author a0225962
 */
public class GraphFSIDelayTrellis_FXMLController implements Initializable {

    @FXML
    private Tab SetRX0CLKvsRX1_TAB;
    @FXML
    private ScrollPane AllGraphsSetRX0CLKvsRX1_SP;
    @FXML
    private VBox AllGraphsSetRX0CLKvsRX1_VB;
    @FXML
    private TableView<ExecutionPointItem> ExecutionPointTable_TV;
    @FXML
    private TableColumn ExecutionPointCLK_TC;
    @FXML
    private TableColumn ExecutionPointRX0_TC;
    @FXML
    private TableColumn ExecutionPointRX1_TC;
    @FXML
    private Label ExecutionPoints_L;

    public static enum GraphMode{
        RX0vsCLK,
        Rx1vsCLK,
        RX0vsRX1,
        SetRX0CLKvsRX1
    }
    
    GraphMode Mode = GraphMode.SetRX0CLKvsRX1;
    
    private Stage ParentStage;
    @FXML
    private VBox AllGraphs_VB;
    @FXML
    private ScrollPane AllGraphs_SP;
    @FXML
    private ScrollPane AllGraphsRX0vsCLK_SP;
    @FXML
    private VBox AllGraphsRX0vsCLK_VB;
    @FXML
    private ScrollPane AllGraphsRX1vsCLK_SP;
    @FXML
    private VBox AllGraphsRX1vsCLK_VB;
    @FXML
    private Tab RX0vsRX1_TAB;
    @FXML
    private Tab RX0vsCLK_TAB;
    @FXML
    private Tab RX1vsCLK_TAB;
    @FXML
    private TabPane TabPzne_TP;
    
    @Override
    public void initialize(URL url, ResourceBundle rb) {
        
    }    
    
    public void SetStage(Stage stage) {
         ParentStage = stage;
    }
    
    public void SetMode(GraphMode mode)
    {
        Mode = mode;
    }
    
    public void SetData(boolean[][][] data, FSIExecutionPoint execPoint)
    {
        if (data != null)
        {
            if (execPoint == null)
            {
                Mode = GraphMode.Rx1vsCLK;
            }
            else
            {
                Mode = GraphMode.SetRX0CLKvsRX1;
            }
            
            if (Mode == GraphMode.RX0vsRX1)
            {
                CreateRX0vsRX1Charts(data);
                TabPzne_TP.getTabs().remove(RX0vsCLK_TAB);
                TabPzne_TP.getTabs().remove(RX1vsCLK_TAB);
                TabPzne_TP.getTabs().remove(SetRX0CLKvsRX1_TAB);
            }
            else if (Mode == GraphMode.RX0vsCLK)
            {
                CreateRX0vsCLKCharts(data);
                TabPzne_TP.getTabs().remove(RX0vsRX1_TAB);
                TabPzne_TP.getTabs().remove(RX1vsCLK_TAB);
                TabPzne_TP.getTabs().remove(SetRX0CLKvsRX1_TAB);
            }
            else if (Mode == GraphMode.Rx1vsCLK)
            {
                CreateRX1vsCLKCharts(data);
                TabPzne_TP.getTabs().remove(RX0vsRX1_TAB);
                TabPzne_TP.getTabs().remove(RX0vsCLK_TAB);
                TabPzne_TP.getTabs().remove(SetRX0CLKvsRX1_TAB);
            }
            else
            {
                if (execPoint != null)
                {
                    CreateSetRX0CLKvsRX1Chart(data, execPoint);
                    TabPzne_TP.getTabs().remove(RX0vsCLK_TAB);
                    TabPzne_TP.getTabs().remove(RX0vsRX1_TAB);
                    TabPzne_TP.getTabs().remove(RX1vsCLK_TAB);
                }
            }
        }
    }
        
    private void CreateSetRX0CLKvsRX1Chart(boolean[][][] data, FSIExecutionPoint execPoint) {
        final NumberAxis xAxis = new NumberAxis(-1, 32, 2);
        final NumberAxis yAxis = new NumberAxis(-1, 32, 2);
        xAxis.setLabel("CLK Delay");
        yAxis.setLabel("RX1 Delay");
        final BubbleChart<Number,Number> blc = new
                BubbleChart<>(xAxis,yAxis);
        blc.setTitle("RX1 Delay vs. Set RX0 and CLK ");
        XYChart.Series successSeries = new XYChart.Series();
        successSeries.setName("Success");

        XYChart.Series failSeries = new XYChart.Series();
        failSeries.setName("Failure");
        
        RX1vsCLKCollection rx1VsCLK = FSICore.GenerateSingleLineRX1vsCLKArray(data, execPoint);
        FSIExecutionPoint dualLineExePoint = FSICore.CalculateDualLineExecutionPoint(rx1VsCLK);
        
        for (int clk = 0; clk < 32; clk++)
        {
            for (int rx1 = 0; rx1 < 32; rx1++)
            {
                if (rx1VsCLK.GetStatus(clk, rx1))
                {
                    successSeries.getData().add(
                            new XYChart.Data(clk, rx1, 0.4));
                }
                else
                {
                    failSeries.getData().add(
                            new XYChart.Data(clk, rx1, 0.1));
                }
            }
        }
        
        
        blc.getData().addAll(successSeries); 
        blc.getData().addAll(failSeries); 
        blc.prefHeightProperty().bind(AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.maxHeightProperty().bind(AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.minHeightProperty().bind(AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.prefWidthProperty().bind(AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.maxWidthProperty().bind(AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.minWidthProperty().bind(AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        
        
        AddExecutionPointToChart(blc, dualLineExePoint);
        SetExecutionPointTable(dualLineExePoint);
        ExecutionPoints_L.setText("Selected Execution Point: "
         + "(CLK = " + dualLineExePoint.CLKDelay + ", RX0 = "
        + dualLineExePoint.RX0Delay + ", RX1 = " + dualLineExePoint.RX1Delay + ")");

        AllGraphsSetRX0CLKvsRX1_VB.getChildren().add(blc);
    }
    
    public void AddExecutionPointToChart(BubbleChart chart, FSIExecutionPoint point)
    {
        if (point != null)
        {            
            XYChart.Series execPointSeries = new XYChart.Series();
            execPointSeries.setName("Execution Point");
            execPointSeries.getData().add(
                    new XYChart.Data(point.CLKDelay, point.RX1Delay, 0.5));
            
            int y = point.RX1Delay;
            
            for (int x = point.CLKDelay; x < 32; x++)
            {
                if (y < 32)
                {
                    execPointSeries.getData().add(
                        new XYChart.Data(x, y, 0.2));
                    int offset = x - point.CLKDelay;
                    //RX0 point.RX0Delay + offset 
                    //RX1 y
                    //CLK x
                    
                    
                }
                y++;
            }
            
            chart.getData().add(execPointSeries);
            
        }
    }
    
    private void SetExecutionPointTable(FSIExecutionPoint point)
    {
        ObservableList<ExecutionPointItem> tableData =
        FXCollections.observableArrayList(
        );
        ExecutionPointCLK_TC.setCellValueFactory(
                new PropertyValueFactory<>("clk"));
        ExecutionPointRX0_TC.setCellValueFactory(
                new PropertyValueFactory<>("rx0"));
        ExecutionPointRX1_TC.setCellValueFactory(
                new PropertyValueFactory<>("rx1"));
        ExecutionPointTable_TV.setItems(tableData);
        
        if (point != null)
        {                        
            int y = point.RX1Delay;
            
            for (int x = point.CLKDelay; x < 32; x++)
            {
                if (y < 32)
                {
                    int offset = x - point.CLKDelay;
                    
                    tableData.add(new ExecutionPointItem(
                            point.RX0Delay + offset, y, x));
                }
                y++;
            }            
        }
    }
    
    public void CreateRX0vsRX1Charts(boolean [][][] data)
    {
        for (int clk = 0; clk < 32; clk++)
        {
            final NumberAxis xAxis = new NumberAxis(-1, 32, 2);
            final NumberAxis yAxis = new NumberAxis(-1, 32, 2);
            xAxis.setLabel("RX0 Delay");
            yAxis.setLabel("RX1 Delay");
            final BubbleChart<Number,Number> blc = new
                    BubbleChart<>(xAxis,yAxis);
            blc.setTitle("CLK Delay " + String.valueOf(clk));
            XYChart.Series successSeries = new XYChart.Series();
            successSeries.setName("Success");
            
            XYChart.Series failSeries = new XYChart.Series();
            failSeries.setName("Failure");
            for (int rx0 = 0; rx0 < 32; rx0++)
            {
                for (int rx1 = 0; rx1 < 32; rx1++)
                {
                    if (data[clk][rx0][rx1])
                    {
                        successSeries.getData().add(
                                new XYChart.Data(rx0, rx1, 0.4));
                    }
                    else
                    {
                        failSeries.getData().add(
                                new XYChart.Data(rx0, rx1, 0.1));
                    }
                }
            }
            blc.getData().addAll(successSeries); 
            blc.getData().addAll(failSeries); 
            blc.prefHeightProperty().bind(AllGraphs_SP.heightProperty());
            blc.maxHeightProperty().bind(AllGraphs_SP.heightProperty());
            blc.minHeightProperty().bind(AllGraphs_SP.heightProperty());
            blc.prefWidthProperty().bind(AllGraphs_SP.heightProperty());
            blc.maxWidthProperty().bind(AllGraphs_SP.heightProperty());
            blc.minWidthProperty().bind(AllGraphs_SP.heightProperty());
            
            AllGraphs_VB.getChildren().add(blc);
        }
    }
    
    public void CreateRX0vsCLKCharts(boolean [][][] data)
    {
        for (int rx1 = 0; rx1 < 32; rx1++)
        {
            final NumberAxis xAxis = new NumberAxis(-1, 32, 2);
            final NumberAxis yAxis = new NumberAxis(-1, 32, 2);
            xAxis.setLabel("RX0 Delay");
            yAxis.setLabel("CLK Delay");
            final BubbleChart<Number,Number> blc = new
                    BubbleChart<>(xAxis,yAxis);
            blc.setTitle("RX1 Delay " + String.valueOf(rx1));
            XYChart.Series successSeries = new XYChart.Series();
            successSeries.setName("Success");
            
            XYChart.Series failSeries = new XYChart.Series();
            failSeries.setName("Failure");
            for (int clk = 0; clk < 32; clk++)
            {
                for (int rx0 = 0; rx0 < 32; rx0++)
                {
                    if (data[clk][rx0][rx1])
                    {
                        successSeries.getData().add(
                                new XYChart.Data(rx0, clk, 0.4));
                    }
                    else
                    {
                        failSeries.getData().add(
                                new XYChart.Data(rx0, clk, 0.1));
                    }
                }
            }
            blc.getData().addAll(successSeries); 
            blc.getData().addAll(failSeries); 
            blc.prefHeightProperty().bind(AllGraphsRX0vsCLK_SP.heightProperty());
            blc.maxHeightProperty().bind(AllGraphsRX0vsCLK_SP.heightProperty());
            blc.minHeightProperty().bind(AllGraphsRX0vsCLK_SP.heightProperty());
            blc.prefWidthProperty().bind(AllGraphsRX0vsCLK_SP.heightProperty());
            blc.maxWidthProperty().bind(AllGraphsRX0vsCLK_SP.heightProperty());
            blc.minWidthProperty().bind(AllGraphsRX0vsCLK_SP.heightProperty());
            
            AllGraphsRX0vsCLK_VB.getChildren().add(blc);
        }
    }

    
    public void CreateRX1vsCLKCharts(boolean [][][] data)
    {
        for (int rx0 = 0; rx0 < 32; rx0++)
        {
            final NumberAxis xAxis = new NumberAxis(-1, 32, 2);
            final NumberAxis yAxis = new NumberAxis(-1, 32, 2);
            xAxis.setLabel("RX1 Delay");
            yAxis.setLabel("CLK Delay");
            final BubbleChart<Number,Number> blc = new
                    BubbleChart<>(xAxis,yAxis);
            blc.setTitle("RX0 Delay " + String.valueOf(rx0));
            XYChart.Series successSeries = new XYChart.Series();
            successSeries.setName("Success");
            
            XYChart.Series failSeries = new XYChart.Series();
            failSeries.setName("Failure");
            for (int clk = 0; clk < 32; clk++)
            {
                for (int rx1 = 0; rx1 < 32; rx1++)
                {
                    if (data[clk][rx0][rx1])
                    {
                        successSeries.getData().add(
                                new XYChart.Data(rx1, clk, 0.4));
                    }
                    else
                    {
                        failSeries.getData().add(
                                new XYChart.Data(rx1, clk, 0.1));
                    }
                }
            }
            blc.getData().addAll(successSeries); 
            blc.getData().addAll(failSeries); 
            blc.prefHeightProperty().bind(AllGraphsRX1vsCLK_SP.heightProperty());
            blc.maxHeightProperty().bind(AllGraphsRX1vsCLK_SP.heightProperty());
            blc.minHeightProperty().bind(AllGraphsRX1vsCLK_SP.heightProperty());
            blc.prefWidthProperty().bind(AllGraphsRX1vsCLK_SP.heightProperty());
            blc.maxWidthProperty().bind(AllGraphsRX1vsCLK_SP.heightProperty());
            blc.minWidthProperty().bind(AllGraphsRX1vsCLK_SP.heightProperty());
            
            AllGraphsRX1vsCLK_VB.getChildren().add(blc);
        }
    }
    
    private void screenshot(ActionEvent event) {
                
        WritableImage image = AllGraphs_VB.getChildren().get(0).snapshot(new SnapshotParameters(), null);
        File file = new File("chart.png");

        try {
            ImageIO.write(SwingFXUtils.fromFXImage(image, null), "png", file);
        } catch (IOException e) {
            // TODO: handle exception here
            e.printStackTrace();
        }
        
        PrinterJob job = PrinterJob.createPrinterJob();
        if(job != null){
          job.showPrintDialog(ParentStage); // Window must be your main Stage
          job.printPage(AllGraphs_VB);
          job.endJob();
        }
    }
    
    
    public class ExecutionPointItem{
        private final SimpleIntegerProperty clk;
        private final SimpleIntegerProperty rx0;
        private final SimpleIntegerProperty rx1;
 
        private ExecutionPointItem(int rx0, int rx1, int clk) {
            this.clk = new SimpleIntegerProperty(clk);
            this.rx0 = new SimpleIntegerProperty(rx0);
            this.rx1 = new SimpleIntegerProperty(rx1);
        }
        
        public int getClk() {
            return clk.get();
        }
 
        public void setClk(int clk) {
            this.clk.set(clk);
        }
        
        
        public int getRx0() {
            return rx0.get();
        }
 
        public void setRx0(int rx0) {
            this.rx0.set(rx0);
        }
        
        
        public int getRx1() {
            return rx1.get();
        }
 
        public void setRx1(int rx1) {
            this.rx1.set(rx1);
        }
        
    }
    
}
