************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE : JULY 1999
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
    .OPTIONS search='./'
***********************************************************************
* DEVICE NETLIST
***********************************************************************
X_DEVICE_SELECTOR  0 CBTLV1G125INC


***********************************************************************
*ENCRYPTED PROCESS MODEL. PLEASE CHOOSE ONLY ONE 
*PROCESS MODEL FILE (NOMINAL, STRONG or WEAK)
***********************************************************************

      X_PROCESS_SELECTOR 0 ASL3C_BSIM3_NINC   $NOMINAL LEVEL 49 PROCESS MODEL 
*      X_PROCESS_SELECTOR 0 ASL3C_BSIM3_SINC   $STRONG  LEVEL 49 PROCESS MODEL
*       X_PROCESS_SELECTOR 0 ASL3C_BSIM3_WINC   $WEAK    LEVEL 49 PROCESS MODEL

*PACKAGE FILE. PLEASE CHOOSE ONLY ONE PACKAGE FILE and change the 
*corresponding subcircuit connection. For example change DBV5_01 to
*DCK5_01
***********************************************************************

.INCLUDE  'DBV5.PKG'
*.INCLUDE  'DCK5.PKG'


***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************

xCBTLV1G125 
+x_NOE
+x_A
+x_B
+x_CVCC
+x_CGND
+CBTLV1G125

***********************************************************************
******Supply Voltages
***********************************************************************
v_vcc     x_CVCC      0     DC     3.3
v_gnd     x_CGND      0     DC     0

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.subckt CBTLV1G125 
+p_noe
+p_a
+p_b
+p_CVCC
+p_CGND


X_PIN_1		p_noe		noe	DBV5_01
X_PIN_2		p_a		a	DBV5_02
X_PIN_3		p_CGND		CGND	DBV5_03
X_PIN_4		p_b		b	DBV5_04
X_PIN_5		p_CVCC		CVCC    DBV5_05
	

X_CBTLV1G125_die noe a b CVCC CGND cbtlv1g125__bit

 
.ENDS CBTLV1G125 

***********************************************************************

.TRAN         1NS 100NS



VNOE x_NOE x_CGND  DC 0

R_LOAD_B   x_B    0   500
C_LOAD_B   x_B    0   50pF


    
V_A      	x_A      0 PULSE (0 5  5NS  1NS  1NS  30NS  60NS)


 
.PRINT TRAN V(x_B)

.END
                                         




