******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for TS3DDR3812
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2010, (C) COPYRIGHT 2010, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
 .INCLUDE 'ts3ddr3812.inc'
X__TS3DDR3812 VCC A0 A1 A2 A3 A4 A5 EN SEL1 SEL2 A6 A7 A8 A9 A10 A11 GND C11
+ B11 C10 B10 C9 B9 C8 B8 C7 B7 C6 B6 C5 B5 C4 B4 C3 B3 C2 B2 C1 B1 C0 B0
+ TS3DDR3812
*** PULSE PARAMETERS ***
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage

*** TRANSIENT START & START PARAMETERS ***
.TRAN 0.05n 400n 0 0.05n


* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 EN GND PWL  0 0 3n 0 5n 'PVCC' 1u 'PVCC'
VC1 SEL1 0 DC 0
VC2 SEL2 0 DC 0


*** SET INPUT AND TEST OUTPUT ****
VP0 A0 GND PULSE 0 2.5 5ns 2ns 2ns 8ns 20ns

* THE OUTPUT NODE termination
RLOAD B0 GND 200
CLOAD B0 GND 4p

* VOLTAGE SUPPLIES

.param PVCC=3.3
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

**I/O nodes terminations 
R1G_3 A1 0 1G
R1G_4 A2 0 1G
R1G_5 A3 0 1G
R1G_6 A4 0 1G
R1G_7 A5 0 1G
R1G_11 A6 0 1G
R1G_12 A7 0 1G
R1G_13 A8 0 1G
R1G_14 A9 0 1G
R1G_15 A10 0 1G
R1G_16 A11 0 1G
R1G_18 C11 0 200
R1G_19 B11 0 200
R1G_20 C10 0 200
R1G_21 B10 0 200
R1G_22 C9 0 200
R1G_23 B9 0 200
R1G_24 C8 0 200
R1G_25 B8 0 200
R1G_26 C7 0 200
R1G_27 B7 0 200
R1G_28 C6 0 200
R1G_29 B6 0 200
R1G_31 C5 0 200
R1G_32 B5 0 200
R1G_33 C4 0 200
R1G_34 B4 0 200
R1G_35 C3 0 200
R1G_36 B3 0 200
R1G_37 C2 0 200
R1G_38 B2 0 200
R1G_39 C1 0 200
R1G_40 B1 0 200
R1G_41 C0 0 200
C1G_18 C11 0 4p
C1G_19 B11 0 4p
C1G_20 C10 0 4p
C1G_21 B10 0 4p
C1G_22 C9 0 4p
C1G_23 B9 0 4p
C1G_24 C8 0 4p
C1G_25 B8 0 4p
C1G_26 C7 0 4p
C1G_27 B7 0 4p
C1G_28 C6 0 4p
C1G_29 B6 0 4p
C1G_31 C5 0 4p
C1G_32 B5 0 4p
C1G_33 C4 0 4p
C1G_34 B4 0 4p
C1G_35 C3 0 4p
C1G_36 B3 0 4p
C1G_37 C2 0 4p
C1G_38 B2 0 4p
C1G_39 C1 0 4p
C1G_40 B1 0 4p
C1G_41 C0 0 4p


.END
