//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
//Firmware Bytes
// |Y3|Y2|Y1|Y0|M3|M2|M1|M0| Where Y3:Y0 = 4 bit code for year from 2007 to 2022 and M3:M0 = 4 bit code for month from Jan (0x00) to Dec (0x0B)
// |D4|D3|D2|D1|D0|H4|H3|H2| Where D4:D0 = 5 bit code for day from 1 (0x00) to 31 (0x1E) and H4:H2 = 3 MSB code for Hour from 0:00 AM (0x00) to .
// |H1|H0|N5|N4|N3|N2|N1|N0| Where H1:H0  = 2 MSB code for Hour and N5:N0 = 6 bit code for minute from 0 to 63.

#define FIRST_YEAR      2007
#define CURRENT_YEAR    2009                            // Change This During Release (IF NEEDED)
#define RELEASE_YEAR    CURRENT_YEAR - FIRST_YEAR

#define JAN             0x00
#define FEB             0x01
#define MAR             0x02
#define APR             0x03
#define MAY             0x04
#define JUN             0x05
#define JUL             0x06
#define AUG             0x07
#define SEP             0x08
#define OCT             0x09
#define NOV             0x0A
#define DEC             0x0B
#define RELEASE_MONTH   APR                             // Change This During Release (IF NEEDED)

#define CURRENT_DAY     2                               // Change This During Release (IF NEEDED)
#define RELEASE_DAY     CURRENT_DAY - 1

#define RELEASE_HOUR    0x03                             // Change This During Release (IF NEEDED)

#define RELEASE_MINUTE  0x30                              // Change This During Release (IF NEEDED)

#define FIRMWARE_RELEASE_3      (RELEASE_YEAR << 4) + RELEASE_MONTH
#define FIRMWARE_RELEASE_2      (RELEASE_DAY << 3) + ((RELEASE_HOUR & 0x1C) >> 2)
#define FIRMWARE_RELEASE_1      ((RELEASE_HOUR & 0x03) << 6) + RELEASE_MINUTE

//#define FIRMWARE_RELEASE_L      (RELEASE_DAY << 12) + (RELEASE_HOUR << 8) + RELEASE_MINUTE
