//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

char StatusLED;
int Frequency[5];
int GPIODirection;
int AccelRate, DesiredStepperSpeed;
int tmpAccelTimeBase, AccelTimeBase;
int AccelerateState;
int StepsToMove;
bool MoveSteps;
void Task0(void)
{
if (MessageComplete)
    {
      SerialOutBuffer[0] = FIRMWARE_REVISION;
      SerialOutBuffer[1] = 0;
      SerialOutBuffer[2] = 0;
      switch(OPCODE)
      {

// Configure GPIO Direction [ OPCODE = 2 ] [ GPIO DIR ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (GPIO_DIR):
            int tempOut;

            GPIODirection =0;

            tempOut = P4DIR;                            //P4DIR = GPIO3/GPIO2/GPIO1/GPIO0/OUT-TMR3/OUT-TMR2/OUT-TMR1/OUT-TMR0
            tempOut &= 0x0F;                            //Clear 4 MSB in original Direction Register
            tempOut |= (SerialBuffer[1] & 0x0F) << 4;   //Received Data Byte's (RDB) 4 MSB cleared. RDB's 4 LSB shifted into 4 MSB
            P4DIR = tempOut;

            GPIODirection = P4DIR << 8;

            tempOut = P1DIR;                            //P1OUT = NU/NU/NU/NU/GPIO7/GPIO6/GPIO5/GPIO4
            tempOut &= 0xF0;                            //Clear 4 LSB in original Direction Register
            tempOut |= (SerialBuffer[1] & 0xF0) >> 4;   //Received Data Register (RDB) 4 LSB cleared.
            P1DIR = tempOut;

            GPIODirection |= P1DIR;

            SerialOutBuffer[1] = ~SerialBuffer[1];
            break;
// Write GPIO Data [ OPCODE = 3 ] [ GPIO DATA ] [ Not Used ] [ Not Used ] [ Not Used ]
// GPIO DATA = P13/P12/P11/P10/P47/P46/P45/P44
      case (WRITE_GPIO):

            tempOut = P4OUT;                            //P4OUT = GPIO3/GPIO2/GPIO1/GPIO0/TMR3/TMR2/TMR1/TMR0
            tempOut &= 0x0F;                            //Clear 4 MSB in original Output Register
            tempOut |= (SerialBuffer[1] & 0x0F) << 4;   //Received Data Bytes (RDB) 4 MSB cleared. RDB's 4 LSB shifted into 4 MSB
            P4OUT = tempOut;

            tempOut = P5OUT;                            //P1OUT = NU/NU/NU/NU/GPIO7/GPIO6/GPIO5/GPIO4
            tempOut &= 0xF0;                            //Clear 4 LSB in original Output Register
            tempOut |= (SerialBuffer[1] & 0xF0) >> 4;   //Received Data Register (RDB) 4 LSB cleared.
            P5OUT = tempOut;

            SerialOutBuffer[1] = ~SerialBuffer[1];
            break;
// Read GPIO Data [ OPCODE = 4 ] [ Not Used ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (READ_GPIO):
            int Temp1, Temp2;
            Temp1 = P4IN >>4;
            Temp2 = P1IN & 0x0F;
            Temp2 <<= 4;
            SerialOutBuffer[1] = Temp2 + Temp1;
            break;
// DAC 0 Config and Write [ OPCODE = 5 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC0_UPDATE):
            DAC12_0CTL = 0;
            DAC12_0CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_0DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
// DAC 1 Config and Write [ OPCODE = 6 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC1_UPDATE):
            DAC12_1CTL = 0;
            DAC12_1CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_1DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
            // Case (TMP0): break; //Opcode 7
// ADC 1 through 3 Sample and Read [ OPCODE = 8 ] [ Channel # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (READ_ADC):

            ADC12CTL0 &= ~ENC;
            ADC12MCTL0 = SREF_CONF + (SerialBuffer[1] & 0x0F);
            ADC12CTL0 |= ENC + ADC12SC;

            while (ADC12CTL1 & ADC12BUSY);

            SerialOutBuffer[1] = (int) (ADC12MEM0 & 0xFF00) / 256;//testamundi;
            SerialOutBuffer[2] = ADC12MEM0 & 0x00FF;
            break;
            // Case (TMP1): break; //Opcode 9
            // Case (TMP2): break; //Opcode A
// Enable PWM [ OPCODE = 0x0B ] [ Timer # ] [ Duty Cycle ] [ Not Used ] [ Not Used ]
      case (ENABLE_PWM):
        TBCTL |= TB_CNTL_08;                //Configure Timer to run up to FF (8 bit FRC)

        switch (SerialBuffer[1])
        {
        case 0:
            TBCCR0 = SerialBuffer[2];
            tempOut = TBCCTL0;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL0 = tempOut;
        break;
        case 1:
            TBCCR1 = SerialBuffer[2];
            tempOut = TBCCTL1;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL1 = tempOut;
        break;
        case 2:
            TBCCR2 = SerialBuffer[2];
            tempOut = TBCCTL2;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL2 = tempOut;
        break;
        case 3:
            TBCCR3 = SerialBuffer[2];
            tempOut = TBCCTL3;
            tempOut &= 0xFF1F;                // Clear OUTMODx bits; 3 MSB on lower byte
            tempOut |= TB_OUTMOD_RESSET;
            TBCCTL3 = tempOut;
        break;
        }
      break;
// Disable PWM [ OPCODE = 0x0C ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (DISABLE_PWM):

        //(TBCCTL0 + SerialBuffer[1]) &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
          break;
        }
      break;
// Enable PWM [ OPCODE = 0x0D ] [ Timer # ] [ Duty Cycle ] [ Not Used ] [ Not Used ]
      case (UPDATE_PWM):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCR0 = SerialBuffer[2];
        break;
        case 1:
            TBCCR1 = SerialBuffer[2];
        break;
        case 2:
            TBCCR2 = SerialBuffer[2];
        break;
        case 3:
            TBCCR3 = SerialBuffer[2];
        break;
        case 4:
            TBCCR4 = SerialBuffer[2];
        break;
        case 5:
            TBCCR5 = SerialBuffer[2];
        break;
        case 6:
            TBCCR6 = SerialBuffer[2];
        break;
        }
            break;
// Set Timer Output [ OPCODE = 0x0E ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (SET_TMR_OUT):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL0 |= BIT2;                  // Set OUT
          break;
        case 1:
            TBCCTL1 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL1 |= BIT2;                  // Set OUT
          break;
        case 2:
            TBCCTL2 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL2 |= BIT2;                  // Set OUT
          break;
        case 3:
            TBCCTL3 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL3 |= BIT2;                  // Set OUT
          break;
        case 4:
            TBCCTL4 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL4 |= BIT2;                  // Set OUT
          break;
        case 5:
            TBCCTL5 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL5 |= BIT2;                  // Set OUT
          break;
        case 6:
            TBCCTL6 &= 0xFF1B;                // Clear OUTMODx bits and OUT bit; Configures the PWM output to OUTx value, in this case 0
            TBCCTL6 |= BIT2;                  // Set OUT
          break;
        }
        break;
        // Pulse Timer Output [ OPCODE = 0x0F ] [Timer Used] [ Pulse Length Hi ] [ Pulse Length Lo ] [ Not Used ]
      case (PULSE_TMR):
        TBCTL &= ~TB_CNTL_08;                //Configure Timer to run up to FFFF (16 bit FRC)
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL0 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL0 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR0 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 1:
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL1 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR1 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 2:
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL2 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR2 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 3:
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL3 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR3 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        }
        break;
// Set Timer Frequency [ OPCODE = 0x10 ] [ Timer # ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ]
      case (FREQ_TMR):
        TBCTL &= ~TB_CNTL_08;                //Configure Timer to run up to FFFF (16 bit FRC)
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL0 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[0] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR0 = Frequency[0];
            break;
        case 1:
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[1] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR1 = Frequency[1];
            break;
        case 2:
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[2] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR2 = Frequency[2];
            break;
        case 3:
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[3] = (SerialBuffer[2] * 256) + SerialBuffer[3];   //Configure the Frequency Rate
            TBCCR3 = Frequency[3];
            break;
        }
      break;
// Disable Timer Frequency [ OPCODE = 0x11 ] [ Timer # ] [ Not Used ] [ Not Used ] [ Not Used ]
      case (FREQ_TMR_STOP):
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        case 1:
            TBCCTL1 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        case 2:
            TBCCTL2 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        case 3:
            TBCCTL3 &= 0xFF0F;                                          //Disable CC and Interrupt
            break;
        }
         break;

// START STEPPER [ OPCODE = 0x12 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (START_STEPPER):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            DesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            AccelRate = SerialBuffer[3];
            AccelTimeBase = SerialBuffer[4];
            tmpAccelTimeBase = AccelTimeBase;
            Frequency[1] = 0xFFFF;                                       //Slowest Startup Speed
            TBCCR1 = Frequency[1];
            AccelerateState = ACCEL;
        break;
// STOP STEPPER [ OPCODE = 0x13 ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ] [ Not Used ]
      case (STOP_STEPPER):
            AccelerateState = STOP;
            DesiredStepperSpeed = 0xFF00;                               //Speed to stop at
            tmpAccelTimeBase = AccelTimeBase;
      break;
// STEPPER_SPEED [ OPCODE = 0x14 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (STEPPER_SPEED):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            DesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            AccelRate = SerialBuffer[3];
            AccelTimeBase = SerialBuffer[4];
            tmpAccelTimeBase = AccelTimeBase;
            if ((unsigned int)DesiredStepperSpeed < (unsigned int)Frequency[1])
            {
                AccelerateState = ACCEL;
            }
            else
            {
                AccelerateState = DECEL;
            }
      break;
// MOVE_STEPS [ OPCODE = 0x12 ] [ Frequency Hi ] [ Frequency Lo ] [ STEPS Hi ] [ STEPS Lo ]
      case (MOVE_STEPS):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[1] = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            StepsToMove = (SerialBuffer[3] * 256) + SerialBuffer[4];   //Configure the Frequency Rate
            TBCCR1 = Frequency[1];
            MoveSteps = true;
            break;

// Read Memory [Opcode = 0xE0 ] [ Address Hi ] [ Address Lo ] [ Not Used ] [ Not Used ]
      case (READ_MEM):
       int * MyPointer;
       int Address;

       Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
       MyPointer = (int *) Address;
       SerialOutBuffer[1] = (*MyPointer & 0xFF00) >> 8;
       SerialOutBuffer[2] = (*MyPointer & 0xFF);
      break;
// Write Memory [Opcode = 0xE1 ] [ Address Hi ] [ Address Lo ] [ Data Hi ] [ Data Lo ]
      case (WRITE_WMEM):
        int Data;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        Data = (SerialBuffer[3]*256 + SerialBuffer[4]);
        MyPointer = (int *) Address;
        *MyPointer = Data;
        break;

// Write Byte Memory [Opcode = 0xE2 ] [ Address ] [ Address Lo ] [ Data ] [Not Used ]
      case (WRITE_BMEM):
        char BData;
        char * MyPtr;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        BData = SerialBuffer[3];
        MyPtr = (char *) Address;
        *MyPtr = BData;
        break;

      case (GET_FW_REV):
        SerialOutBuffer[0] = (unsigned char)FIRMWARE_RELEASE_3;
        SerialOutBuffer[1] = (unsigned char)FIRMWARE_RELEASE_2;
        SerialOutBuffer[2] = (unsigned char)FIRMWARE_RELEASE_1;
        break;
      case (RESET_MCU):
        WDTCTL = 0x00;
        break;
      case (SHOW_CLKS):
        P5SEL |= SerialBuffer[1] & 0xF0;
        break;
      }
    MessageComplete = false;
    SerialOutPointer = 0;
    TXBUF0 = SerialOutBuffer[SerialOutPointer];
    IE1 |= UTXIE0;
    }
}





