/**
 * Note: This file was auto-generated by TI PinMux on 11/7/2023.
 *
 * \file   AM62x_pinmux.h
 *
 * \brief  This file contains pad configure register offsets and bit-field 
 *         value macros for different configurations,
 *
 *           BIT[21]		TXDISABLE		disable the pin's output driver
 *           BIT[18]		RXACTIVE		enable the pin's input buffer (typically kept enabled)
 *           BIT[17]		PULLTYPESEL		set the iternal resistor pull direction high or low (if enabled)
 *           BIT[16]		PULLUDEN		internal resistor disable (0 = enabled / 1 = disabled)
 *           BIT[3:0]		MUXMODE			select the desired function on the given pin
 *
 *  \copyright Copyright (CU) 2023 Texas Instruments Incorporated - 
 *             http://www.ti.com/
 */

#ifndef _AM62x_PIN_MUX_H_
#define _AM62x_PIN_MUX_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "pinmux.h"
#include "csl_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define PIN_MODE(mode)	                (mode)
#define PINMUX_END                      (-1)

/** \brief Active mode configurations */
/** \brief Resistor enable */
#define PIN_PULL_DISABLE                (0x1U << 16U)
/** \brief Pull direction */
#define	PIN_PULL_DIRECTION              (0x1U << 17U)
/** \brief Receiver enable */
#define	PIN_INPUT_ENABLE                (0x1U << 18U)
/** \brief Driver disable */
#define	PIN_OUTPUT_DISABLE              (0x1U << 21U)
/** \brief Wakeup enable */
#define	PIN_WAKEUP_ENABLE               (0x1U << 29U)

/** \brief Pad config register offset in control module */

enum pinMainOffsets
{
	PIN_VOUT0_VSYNC		 = 0x0100,
	PIN_VOUT0_HSYNC		 = 0x00F8,
	PIN_VOUT0_PCLK		 = 0x0104,
	PIN_VOUT0_DE		 = 0x00FC,
	PIN_VOUT0_DATA0		 = 0x00B8,
	PIN_VOUT0_DATA1		 = 0x00BC,
	PIN_VOUT0_DATA2		 = 0x00C0,
	PIN_VOUT0_DATA3		 = 0x00C4,
	PIN_VOUT0_DATA4		 = 0x00C8,
	PIN_VOUT0_DATA5		 = 0x00CC,
	PIN_VOUT0_DATA6		 = 0x00D0,
	PIN_VOUT0_DATA7		 = 0x00D4,
	PIN_VOUT0_DATA8		 = 0x00D8,
	PIN_VOUT0_DATA9		 = 0x00DC,
	PIN_VOUT0_DATA10		 = 0x00E0,
	PIN_VOUT0_DATA11		 = 0x00E4,
	PIN_VOUT0_DATA12		 = 0x00E8,
	PIN_VOUT0_DATA13		 = 0x00EC,
	PIN_VOUT0_DATA14		 = 0x00F0,
	PIN_VOUT0_DATA15		 = 0x00F4,
	PIN_GPMC0_AD8		 = 0x005C,
	PIN_GPMC0_AD9		 = 0x0060,
	PIN_GPMC0_AD10		 = 0x0064,
	PIN_GPMC0_AD11		 = 0x0068,
	PIN_GPMC0_AD12		 = 0x006C,
	PIN_GPMC0_AD13		 = 0x0070,
	PIN_GPMC0_AD14		 = 0x0074,
	PIN_GPMC0_AD15		 = 0x0078,
	PIN_OSPI0_CSN1		 = 0x0030,
	PIN_OSPI0_CSN3		 = 0x0038,
	PIN_GPMC0_CLK		 = 0x007C,
	PIN_GPMC0_OEN_REN		 = 0x0088,
	PIN_GPMC0_BE1N		 = 0x0094,
	PIN_GPMC0_WAIT1		 = 0x009C,
	PIN_GPMC0_WPN		 = 0x00A0,
	PIN_GPMC0_DIR		 = 0x00A4,
	PIN_GPMC0_CSN0		 = 0x00A8,
	PIN_GPMC0_CSN1		 = 0x00AC,
	PIN_MMC2_SDWP		 = 0x0128,
	PIN_MCASP0_AXR1		 = 0x019C,
	PIN_MCASP0_AXR0		 = 0x01A0,
	PIN_MCASP0_ACLKX		 = 0x01A4,
	PIN_UART0_CTSN		 = 0x01D0,
	PIN_UART0_RTSN		 = 0x01D4,
	PIN_EXTINTN		 = 0x01F4,
	PIN_MMC1_SDWP		 = 0x0244,
	PIN_I2C0_SCL		 = 0x01E0,
	PIN_I2C0_SDA		 = 0x01E4,
	PIN_I2C1_SCL		 = 0x01E8,
	PIN_I2C1_SDA		 = 0x01EC,
	PIN_GPMC0_CSN2		 = 0x00B0,
	PIN_GPMC0_CSN3		 = 0x00B4,
	PIN_GPMC0_BE0N_CLE		 = 0x0090,
	PIN_GPMC0_WAIT0		 = 0x0098,
	PIN_GPMC0_WEN		 = 0x008C,
	PIN_GPMC0_ADVN_ALE		 = 0x0084,
	PIN_MDIO0_MDC		 = 0x0160,
	PIN_MDIO0_MDIO		 = 0x015C,
	PIN_MMC0_CMD		 = 0x0220,
	PIN_MMC0_CLK		 = 0x0218,
	PIN_MMC0_DAT0		 = 0x0214,
	PIN_MMC0_DAT1		 = 0x0210,
	PIN_MMC0_DAT2		 = 0x020C,
	PIN_MMC0_DAT3		 = 0x0208,
	PIN_MMC0_DAT4		 = 0x0204,
	PIN_MMC0_DAT5		 = 0x0200,
	PIN_MMC0_DAT6		 = 0x01FC,
	PIN_MMC0_DAT7		 = 0x01F8,
	PIN_MMC1_CMD		 = 0x023C,
	PIN_MMC1_CLK		 = 0x0234,
	PIN_MMC1_DAT0		 = 0x0230,
	PIN_MMC1_DAT1		 = 0x022C,
	PIN_MMC1_DAT2		 = 0x0228,
	PIN_MMC1_DAT3		 = 0x0224,
	PIN_MMC1_SDCD		 = 0x0240,
	PIN_MMC2_CMD		 = 0x0120,
	PIN_MMC2_CLK		 = 0x0118,
	PIN_MMC2_CLKLB		 = 0x011C,
	PIN_MMC2_DAT0		 = 0x0114,
	PIN_MMC2_DAT1		 = 0x0110,
	PIN_MMC2_DAT2		 = 0x010C,
	PIN_MMC2_DAT3		 = 0x0108,
	PIN_MMC2_SDCD		 = 0x0124,
	PIN_OSPI0_CLK		 = 0x0000,
	PIN_OSPI0_CSN0		 = 0x002C,
	PIN_OSPI0_D0		 = 0x000C,
	PIN_OSPI0_D1		 = 0x0010,
	PIN_OSPI0_D2		 = 0x0014,
	PIN_OSPI0_D3		 = 0x0018,
	PIN_OSPI0_D4		 = 0x001C,
	PIN_OSPI0_D5		 = 0x0020,
	PIN_OSPI0_D6		 = 0x0024,
	PIN_OSPI0_D7		 = 0x0028,
	PIN_OSPI0_DQS		 = 0x0008,
	PIN_OSPI0_LBCLKO		 = 0x0004,
	PIN_GPMC0_AD0		 = 0x003C,
	PIN_GPMC0_AD1		 = 0x0040,
	PIN_GPMC0_AD2		 = 0x0044,
	PIN_GPMC0_AD3		 = 0x0048,
	PIN_GPMC0_AD4		 = 0x004C,
	PIN_GPMC0_AD5		 = 0x0050,
	PIN_GPMC0_AD6		 = 0x0054,
	PIN_GPMC0_AD7		 = 0x0058,
	PIN_RGMII1_RD0		 = 0x014C,
	PIN_RGMII1_RD1		 = 0x0150,
	PIN_RGMII1_RD2		 = 0x0154,
	PIN_RGMII1_RD3		 = 0x0158,
	PIN_RGMII1_RXC		 = 0x0148,
	PIN_RGMII1_RX_CTL		 = 0x0144,
	PIN_RGMII1_TD0		 = 0x0134,
	PIN_RGMII1_TD1		 = 0x0138,
	PIN_RGMII1_TD2		 = 0x013C,
	PIN_RGMII1_TD3		 = 0x0140,
	PIN_RGMII1_TXC		 = 0x0130,
	PIN_RGMII1_TX_CTL		 = 0x012C,
	PIN_RGMII2_RD0		 = 0x0184,
	PIN_RGMII2_RD1		 = 0x0188,
	PIN_RGMII2_RD2		 = 0x018C,
	PIN_RGMII2_RD3		 = 0x0190,
	PIN_RGMII2_RXC		 = 0x0180,
	PIN_RGMII2_RX_CTL		 = 0x017C,
	PIN_RGMII2_TD0		 = 0x016C,
	PIN_RGMII2_TD1		 = 0x0170,
	PIN_RGMII2_TD2		 = 0x0174,
	PIN_RGMII2_TD3		 = 0x0178,
	PIN_RGMII2_TXC		 = 0x0168,
	PIN_RGMII2_TX_CTL		 = 0x0164,
	PIN_SPI0_CLK		 = 0x01BC,
	PIN_SPI0_CS0		 = 0x01B4,
	PIN_SPI0_CS1		 = 0x01B8,
	PIN_SPI0_D0		 = 0x01C0,
	PIN_SPI0_D1		 = 0x01C4,
	PIN_MCASP0_AFSX		 = 0x01A8,
	PIN_EXT_REFCLK1		 = 0x01F0,
	PIN_PORZ_OUT		 = 0x0250,
	PIN_RESETSTATZ		 = 0x024C,
	PIN_RESET_REQZ		 = 0x0248,
	PIN_UART0_RXD		 = 0x01C8,
	PIN_UART0_TXD		 = 0x01CC,
	PIN_MCASP0_AXR3		 = 0x0194,
	PIN_MCASP0_AXR2		 = 0x0198,
	PIN_MCASP0_AFSR		 = 0x01AC,
	PIN_MCASP0_ACLKR		 = 0x01B0,
	PIN_MCAN0_TX		 = 0x01D8,
	PIN_MCAN0_RX		 = 0x01DC,
	PIN_USB0_DRVVBUS		 = 0x0254,
	PIN_USB1_DRVVBUS		 = 0x0258,
};

enum pinMcuOffsets
{
	PIN_MCU_SPI0_CS0		 = 0x0000,
	PIN_MCU_MCAN1_TX		 = 0x003C,
	PIN_MCU_MCAN1_RX		 = 0x0040,
	PIN_WKUP_I2C0_SCL		 = 0x004C,
	PIN_WKUP_I2C0_SDA		 = 0x0050,
	PIN_PMIC_LPM_EN0		 = 0x0080,
	PIN_MCU_I2C0_SCL		 = 0x0044,
	PIN_MCU_I2C0_SDA		 = 0x0048,
	PIN_MCU_MCAN0_RX		 = 0x0038,
	PIN_MCU_MCAN0_TX		 = 0x0034,
	PIN_MCU_SPI0_CLK		 = 0x0008,
	PIN_MCU_SPI0_CS1		 = 0x0004,
	PIN_MCU_SPI0_D0		 = 0x000C,
	PIN_MCU_SPI0_D1		 = 0x0010,
	PIN_MCU_ERRORN		 = 0x0060,
	PIN_MCU_PORZ		 = 0x0058,
	PIN_MCU_RESETSTATZ		 = 0x005C,
	PIN_MCU_RESETZ		 = 0x0054,
	PIN_MCU_UART0_CTSN		 = 0x001C,
	PIN_MCU_UART0_RTSN		 = 0x0020,
	PIN_MCU_UART0_RXD		 = 0x0014,
	PIN_MCU_UART0_TXD		 = 0x0018,
	PIN_WKUP_CLKOUT0		 = 0x0084,
	PIN_WKUP_UART0_CTSN		 = 0x002C,
	PIN_WKUP_UART0_RTSN		 = 0x0030,
	PIN_WKUP_UART0_RXD		 = 0x0024,
	PIN_WKUP_UART0_TXD		 = 0x0028,
};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/** \brief Pinmux configuration data for the board. Auto-generated from 
           Pinmux tool. */
extern pinmuxBoardCfg_t gAM62x_MainPinmuxData[];
extern pinmuxBoardCfg_t gAM62x_McuPinmuxData[];

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* _AM62x_PIN_MUX_H_ */
